// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyConnCompReduceAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyConnCompReduceAttributes
//
// Purpose:
//   This class contains attributes for the reduce connected components operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ConnCompReduceAttributes.
//
struct ConnCompReduceAttributesObject
{
    PyObject_HEAD
    ConnCompReduceAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewConnCompReduceAttributes(int);

std::string
PyConnCompReduceAttributes_ToString(const ConnCompReduceAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%starget = %g\n", prefix, atts->GetTarget());
    str += tmpStr;
    return str;
}

static PyObject *
ConnCompReduceAttributes_Notify(PyObject *self, PyObject *args)
{
    ConnCompReduceAttributesObject *obj = (ConnCompReduceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConnCompReduceAttributes_SetTarget(PyObject *self, PyObject *args)
{
    ConnCompReduceAttributesObject *obj = (ConnCompReduceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the target in the object.
    obj->data->SetTarget(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConnCompReduceAttributes_GetTarget(PyObject *self, PyObject *args)
{
    ConnCompReduceAttributesObject *obj = (ConnCompReduceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTarget());
    return retval;
}



PyMethodDef PyConnCompReduceAttributes_methods[CONNCOMPREDUCEATTRIBUTES_NMETH] = {
    {"Notify", ConnCompReduceAttributes_Notify, METH_VARARGS},
    {"SetTarget", ConnCompReduceAttributes_SetTarget, METH_VARARGS},
    {"GetTarget", ConnCompReduceAttributes_GetTarget, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ConnCompReduceAttributes_dealloc(PyObject *v)
{
   ConnCompReduceAttributesObject *obj = (ConnCompReduceAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ConnCompReduceAttributes_compare(PyObject *v, PyObject *w)
{
    ConnCompReduceAttributes *a = ((ConnCompReduceAttributesObject *)v)->data;
    ConnCompReduceAttributes *b = ((ConnCompReduceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyConnCompReduceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "target") == 0)
        return ConnCompReduceAttributes_GetTarget(self, NULL);

    return Py_FindMethod(PyConnCompReduceAttributes_methods, self, name);
}

int
PyConnCompReduceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "target") == 0)
        obj = ConnCompReduceAttributes_SetTarget(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ConnCompReduceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ConnCompReduceAttributesObject *obj = (ConnCompReduceAttributesObject *)v;
    fprintf(fp, "%s", PyConnCompReduceAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ConnCompReduceAttributes_str(PyObject *v)
{
    ConnCompReduceAttributesObject *obj = (ConnCompReduceAttributesObject *)v;
    return PyString_FromString(PyConnCompReduceAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ConnCompReduceAttributes_Purpose = "This class contains attributes for the reduce connected components operator.";
#else
static char *ConnCompReduceAttributes_Purpose = "This class contains attributes for the reduce connected components operator.";
#endif

//
// The type description structure
//
static PyTypeObject ConnCompReduceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ConnCompReduceAttributes",                    // tp_name
    sizeof(ConnCompReduceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ConnCompReduceAttributes_dealloc,  // tp_dealloc
    (printfunc)ConnCompReduceAttributes_print,     // tp_print
    (getattrfunc)PyConnCompReduceAttributes_getattr, // tp_getattr
    (setattrfunc)PyConnCompReduceAttributes_setattr, // tp_setattr
    (cmpfunc)ConnCompReduceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ConnCompReduceAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ConnCompReduceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ConnCompReduceAttributes *defaultAtts = 0;
static ConnCompReduceAttributes *currentAtts = 0;

static PyObject *
NewConnCompReduceAttributes(int useCurrent)
{
    ConnCompReduceAttributesObject *newObject;
    newObject = PyObject_NEW(ConnCompReduceAttributesObject, &ConnCompReduceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ConnCompReduceAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ConnCompReduceAttributes(*defaultAtts);
    else
        newObject->data = new ConnCompReduceAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapConnCompReduceAttributes(const ConnCompReduceAttributes *attr)
{
    ConnCompReduceAttributesObject *newObject;
    newObject = PyObject_NEW(ConnCompReduceAttributesObject, &ConnCompReduceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ConnCompReduceAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ConnCompReduceAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewConnCompReduceAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ConnCompReduceAttributesMethods[] = {
    {"ConnCompReduceAttributes", ConnCompReduceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ConnCompReduceAttributesObserver = 0;

std::string
PyConnCompReduceAttributes_GetLogString()
{
    std::string s("ConnCompReduceAtts = ConnCompReduceAttributes()\n");
    if(currentAtts != 0)
        s += PyConnCompReduceAttributes_ToString(currentAtts, "ConnCompReduceAtts.");
    return s;
}

static void
PyConnCompReduceAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ConnCompReduceAtts = ConnCompReduceAttributes()\n");
        s += PyConnCompReduceAttributes_ToString(currentAtts, "ConnCompReduceAtts.");
        cb(s);
    }
}

void
PyConnCompReduceAttributes_StartUp(ConnCompReduceAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyConnCompReduceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ConnCompReduceAttributesObserver == 0)
    {
        ConnCompReduceAttributesObserver = new ObserverToCallback(subj,
            PyConnCompReduceAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyConnCompReduceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ConnCompReduceAttributesObserver;
    ConnCompReduceAttributesObserver = 0;
}

PyMethodDef *
PyConnCompReduceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ConnCompReduceAttributesMethods;
}

bool
PyConnCompReduceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ConnCompReduceAttributesType);
}

ConnCompReduceAttributes *
PyConnCompReduceAttributes_FromPyObject(PyObject *obj)
{
    ConnCompReduceAttributesObject *obj2 = (ConnCompReduceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyConnCompReduceAttributes_New()
{
    return NewConnCompReduceAttributes(0);
}

PyObject *
PyConnCompReduceAttributes_Wrap(const ConnCompReduceAttributes *attr)
{
    return WrapConnCompReduceAttributes(attr);
}

void
PyConnCompReduceAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ConnCompReduceAttributesObject *obj2 = (ConnCompReduceAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyConnCompReduceAttributes_SetDefaults(const ConnCompReduceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ConnCompReduceAttributes(*atts);
}

