// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtCartographicProjectionFilter.h
// ************************************************************************* //

#ifndef AVT_CartographicProjection_FILTER_H
#define AVT_CartographicProjection_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <CartographicProjectionAttributes.h>


// ****************************************************************************
//  Class: avtCartographicProjectionFilter
//
//  Purpose:
//      A plugin operator for CartographicProjection.
//
//  Programmer: jfavre -- generated by xml2avt
//  Creation:   Fri Sep 7 14:25:48 PST 2012
//
//  Modifications:
//    Eric Brugger, Wed Jul 23 08:30:00 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtCartographicProjectionFilter : public avtPluginDataTreeIterator
{
  public:
                         avtCartographicProjectionFilter();
    virtual             ~avtCartographicProjectionFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtCartographicProjectionFilter"; };
    virtual const char  *GetDescription(void)
                             { return "CartographicProjection"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    CartographicProjectionAttributes   atts;
    void                 UpdateDataObjectInfo(void);
    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
};


#endif
