// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISCARTOGRAPHICPROJECTIONWINDOW_H
#define QVISCARTOGRAPHICPROJECTIONWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class CartographicProjectionAttributes;
class QLabel;
class QLineEdit;
class QComboBox;

// ****************************************************************************
// Class: QvisCartographicProjectionWindow
//
// Purpose:
//    Defines QvisCartographicProjectionWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: Jean Favre
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisCartographicProjectionWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisCartographicProjectionWindow(const int type,
                         CartographicProjectionAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisCartographicProjectionWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void projectionIDChanged(int val);
    void centralMeridianProcessText();
  private:
    QComboBox *projectionIDCombo;
    QLineEdit *centralMeridian;
    QLabel    *projectionIDLabel, *centralMeridianLabel;

    CartographicProjectionAttributes *atts;
};



#endif
