// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CartographicProjectionViewerEnginePluginInfo.C
// ****************************************************************************

#include <CartographicProjectionPluginInfo.h>
#include <CartographicProjectionAttributes.h>

//
// Storage for static data elements.
//
CartographicProjectionAttributes *CartographicProjectionViewerEnginePluginInfo::clientAtts = NULL;
CartographicProjectionAttributes *CartographicProjectionViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  CartographicProjectionViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
CartographicProjectionViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (CartographicProjectionViewerEnginePluginInfo::clientAtts == NULL)
    {
        CartographicProjectionViewerEnginePluginInfo::clientAtts  = new CartographicProjectionAttributes;
        CartographicProjectionViewerEnginePluginInfo::defaultAtts = new CartographicProjectionAttributes;
    }
}

// ****************************************************************************
//  Method: CartographicProjectionViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
CartographicProjectionViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: CartographicProjectionViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
CartographicProjectionViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: CartographicProjectionViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
CartographicProjectionViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(CartographicProjectionAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: CartographicProjectionViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
CartographicProjectionViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(CartographicProjectionAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: CartographicProjectionViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
CartographicProjectionViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(CartographicProjectionAttributes*)atts = *defaultAtts;
    else
        *(CartographicProjectionAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: CartographicProjectionViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
CartographicProjectionViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: CartographicProjectionViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CartographicProjectionViewerEnginePluginInfo::GetMenuName() const
{
    return "Cartographic Projection";
}

