// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CartographicProjectionPluginInfo.C
// ****************************************************************************

#include <CartographicProjectionPluginInfo.h>
#include <CartographicProjectionAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(CartographicProjection,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(CartographicProjection,General)

// ****************************************************************************
//  Method: CartographicProjectionGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CartographicProjectionGeneralPluginInfo::GetName() const
{
    return "CartographicProjection";
}

// ****************************************************************************
//  Method: CartographicProjectionGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CartographicProjectionGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: CartographicProjectionGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CartographicProjectionGeneralPluginInfo::GetID() const
{
    return "CartographicProjection_1.0";
}
// ****************************************************************************
//  Method: CartographicProjectionGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
CartographicProjectionGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: CartographicProjectionGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CartographicProjectionGeneralPluginInfo::GetCategoryName() const
{
    return "Transforms";
}
