// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: CartographicProjectionCommonPluginInfo.C
// ****************************************************************************

#include <CartographicProjectionPluginInfo.h>
#include <CartographicProjectionAttributes.h>

// ****************************************************************************
//  Method: CartographicProjectionCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
CartographicProjectionCommonPluginInfo::AllocAttributes()
{
    return new CartographicProjectionAttributes;
}

// ****************************************************************************
//  Method: CartographicProjectionCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a CartographicProjection attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
CartographicProjectionCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((CartographicProjectionAttributes *) to) = *((CartographicProjectionAttributes *) from);
}
