// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef CARTOGRAPHICPROJECTIONATTRIBUTES_H
#define CARTOGRAPHICPROJECTIONATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: CartographicProjectionAttributes
//
// Purpose:
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class CartographicProjectionAttributes : public AttributeSubject
{
public:
    enum ProjectionID
    {
        aitoff,
        eck4,
        eqdc,
        hammer,
        laea,
        lcc,
        merc,
        mill,
        moll,
        ortho,
        wink2
    };

    // These constructors are for objects of this class
    CartographicProjectionAttributes();
    CartographicProjectionAttributes(const CartographicProjectionAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    CartographicProjectionAttributes(private_tmfs_t tmfs);
    CartographicProjectionAttributes(const CartographicProjectionAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~CartographicProjectionAttributes();

    virtual CartographicProjectionAttributes& operator = (const CartographicProjectionAttributes &obj);
    virtual bool operator == (const CartographicProjectionAttributes &obj) const;
    virtual bool operator != (const CartographicProjectionAttributes &obj) const;
private:
    void Init();
    void Copy(const CartographicProjectionAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetProjectionID(ProjectionID projectionID_);
    void SetCentralMeridian(double centralMeridian_);

    // Property getting methods
    ProjectionID GetProjectionID() const;
    double GetCentralMeridian() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string ProjectionID_ToString(ProjectionID);
    static bool ProjectionID_FromString(const std::string &, ProjectionID &);
protected:
    static std::string ProjectionID_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_projectionID = 0,
        ID_centralMeridian,
        ID__LAST
    };

private:
    int    projectionID;
    double centralMeridian;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define CARTOGRAPHICPROJECTIONATTRIBUTES_TMFS "id"

#endif
