// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISBOXWINDOW_H
#define QVISBOXWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class BoxAttributes;
class QLabel;
class QCheckBox;
class QLineEdit;
class QButtonGroup;

// ****************************************************************************
// Class: QvisBoxWindow
//
// Purpose:
//    Defines QvisBoxWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisBoxWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisBoxWindow(const int type,
                         BoxAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisBoxWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void amountChanged(int val);
    void minxProcessText();
    void maxxProcessText();
    void minyProcessText();
    void maxyProcessText();
    void minzProcessText();
    void maxzProcessText();
    void inverseChanged(bool val);
  private:
    QWidget      *amount;
    QButtonGroup *amountButtonGroup;
    QLineEdit *minx;
    QLineEdit *maxx;
    QLineEdit *miny;
    QLineEdit *maxy;
    QLineEdit *minz;
    QLineEdit *maxz;
    QCheckBox *inverse;
    QLabel *amountLabel;
    QLabel *minxLabel;
    QLabel *maxxLabel;
    QLabel *minyLabel;
    QLabel *maxyLabel;
    QLabel *minzLabel;
    QLabel *maxzLabel;

    BoxAttributes *atts;
};



#endif
