// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtBoundaryOpFilter.h
// ************************************************************************* //

#ifndef AVT_Boundary_FILTER_H
#define AVT_Boundary_FILTER_H

#include <avtPluginFilter.h>
#include <avtSmoothPolyDataFilter.h>

#include <BoundaryOpAttributes.h>

class vtkDataSet;


// ****************************************************************************
//  Class: avtBoundaryOpFilter
//
//  Purpose:
//      A plugin operator for Boundary.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
//  Modifications:
//    Eric Brugger, Tue Jul 22 12:42:24 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtBoundaryOpFilter : virtual public avtPluginFilter,
                            virtual public avtSmoothPolyDataFilter
{
  public:
                         avtBoundaryOpFilter();
    virtual             ~avtBoundaryOpFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtBoundaryOpFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Boundary"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    BoundaryOpAttributes   atts;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
    virtual avtContract_p
                          ModifyContract(avtContract_p);
};

#endif
