// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtBoundaryOpFilter.C
// ************************************************************************* //

#include <avtBoundaryOpFilter.h>


// ****************************************************************************
//  Method: avtBoundaryOpFilter constructor
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
// ****************************************************************************

avtBoundaryOpFilter::avtBoundaryOpFilter()
{
}


// ****************************************************************************
//  Method: avtBoundaryOpFilter destructor
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
//  Modifications:
//
// ****************************************************************************

avtBoundaryOpFilter::~avtBoundaryOpFilter()
{
}


// ****************************************************************************
//  Method:  avtBoundaryOpFilter::Create
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
// ****************************************************************************

avtFilter *
avtBoundaryOpFilter::Create()
{
    return new avtBoundaryOpFilter();
}


// ****************************************************************************
//  Method:      avtBoundaryOpFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
// ****************************************************************************

void
avtBoundaryOpFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const BoundaryOpAttributes*)a;
}


// ****************************************************************************
//  Method: avtBoundaryOpFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtBoundaryOpFilter with the given
//      parameters would result in an equivalent avtBoundaryOpFilter.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
// ****************************************************************************

bool
avtBoundaryOpFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(BoundaryOpAttributes*)a);
}


// ****************************************************************************
//  Method: avtBoundaryOpFilter::ExecuteData
//
//  Purpose:
//      Return input data set, which due to contract modifications alreay
//      corresponds to the material interface, performing additional
//      smoothing if necessary.
//
//  Arguments:
//      in_dr      The input data representation.
//
//  Returns:       The output data representation.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
//  Modifications:
//    Eric Brugger, Tue Jul 22 12:43:07 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

avtDataRepresentation *
avtBoundaryOpFilter::ExecuteData(avtDataRepresentation *in_dr)
{
    if (atts.GetSmoothingLevel() > 0)
    {
        SetSmoothingLevel(atts.GetSmoothingLevel());
        return avtSmoothPolyDataFilter::ExecuteData(in_dr);
    }
    else
    {
        return in_dr;
    }
}


// ****************************************************************************
//  Method: avtBoundaryOpFilter::PerformRestricition
//
//  Purpose:
//      Modify contract to request material interface reconstruction.
//
//  Arguments:
//      in_contract  Original contract
//
//  Returns:         Modified contract.
//
//  Programmer: ghweber -- generated by xml2avt
//  Creation:   Tue Aug 14 10:29:41 PDT 2007
//
// ****************************************************************************

avtContract_p
avtBoundaryOpFilter::ModifyContract(avtContract_p in_contract)
{
    avtContract_p out_contract =
       new avtContract(in_contract);

    out_contract->GetDataRequest()->ForceMaterialInterfaceReconstructionOn();
    out_contract->GetDataRequest()->TurnBoundarySurfaceRepresentationOn();

    return out_contract;
}
