// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: BoundaryOpViewerEnginePluginInfo.C
// ****************************************************************************

#include <BoundaryOpPluginInfo.h>
#include <BoundaryOpAttributes.h>

//
// Storage for static data elements.
//
BoundaryOpAttributes *BoundaryOpViewerEnginePluginInfo::clientAtts = NULL;
BoundaryOpAttributes *BoundaryOpViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  BoundaryOpViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
BoundaryOpViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (BoundaryOpViewerEnginePluginInfo::clientAtts == NULL)
    {
        BoundaryOpViewerEnginePluginInfo::clientAtts  = new BoundaryOpAttributes;
        BoundaryOpViewerEnginePluginInfo::defaultAtts = new BoundaryOpAttributes;
    }
}

// ****************************************************************************
//  Method: BoundaryOpViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
BoundaryOpViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: BoundaryOpViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
BoundaryOpViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: BoundaryOpViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
BoundaryOpViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(BoundaryOpAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: BoundaryOpViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
BoundaryOpViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(BoundaryOpAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: BoundaryOpViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
BoundaryOpViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(BoundaryOpAttributes*)atts = *defaultAtts;
    else
        *(BoundaryOpAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: BoundaryOpViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
BoundaryOpViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: BoundaryOpViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
BoundaryOpViewerEnginePluginInfo::GetMenuName() const
{
    return "Boundary";
}

