// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  BoundaryOpScriptingPluginInfo.C
// ************************************************************************* //
#include <PyBoundaryOpAttributes.h>
#include <BoundaryOpPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(BoundaryOp,Scripting)

// ****************************************************************************
// Method: BoundaryOpScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
BoundaryOpScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyBoundaryOpAttributes_StartUp((BoundaryOpAttributes *)subj, data);
}

// ****************************************************************************
// Method: BoundaryOpScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
BoundaryOpScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyBoundaryOpAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: BoundaryOpScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is BoundaryOp plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoundaryOpScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyBoundaryOpAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: BoundaryOpScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
BoundaryOpScriptingPluginInfo::GetLogString()
{
    std::string s(PyBoundaryOpAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: BoundaryOpScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
BoundaryOpScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyBoundaryOpAttributes_SetDefaults((const BoundaryOpAttributes *)atts);
}
