// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: BoundaryOpCommonPluginInfo.C
// ****************************************************************************

#include <BoundaryOpPluginInfo.h>
#include <BoundaryOpAttributes.h>

// ****************************************************************************
//  Method: BoundaryOpCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
BoundaryOpCommonPluginInfo::AllocAttributes()
{
    return new BoundaryOpAttributes;
}

// ****************************************************************************
//  Method: BoundaryOpCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a BoundaryOp attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
BoundaryOpCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((BoundaryOpAttributes *) to) = *((BoundaryOpAttributes *) from);
}
