// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISAXISALIGNEDSLICE4DWINDOW_H
#define QVISAXISALIGNEDSLICE4DWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class AxisAlignedSlice4DAttributes;
class QLabel;
class QLineEdit;

// ****************************************************************************
// Class: QvisAxisAlignedSlice4DWindow
//
// Purpose:
//    Defines QvisAxisAlignedSlice4DWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisAxisAlignedSlice4DWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisAxisAlignedSlice4DWindow(const int type,
                         AxisAlignedSlice4DAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisAxisAlignedSlice4DWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void IProcessText();
    void JProcessText();
    void KProcessText();
    void LProcessText();
  private:
    QLineEdit *I;
    QLineEdit *J;
    QLineEdit *K;
    QLineEdit *L;
    QLabel *ILabel;
    QLabel *JLabel;
    QLabel *KLabel;
    QLabel *LLabel;

    AxisAlignedSlice4DAttributes *atts;
};



#endif
