// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: AxisAlignedSlice4DViewerEnginePluginInfo.C
// ****************************************************************************

#include <AxisAlignedSlice4DPluginInfo.h>
#include <AxisAlignedSlice4DAttributes.h>

//
// Storage for static data elements.
//
AxisAlignedSlice4DAttributes *AxisAlignedSlice4DViewerEnginePluginInfo::clientAtts = NULL;
AxisAlignedSlice4DAttributes *AxisAlignedSlice4DViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  AxisAlignedSlice4DViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
AxisAlignedSlice4DViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (AxisAlignedSlice4DViewerEnginePluginInfo::clientAtts == NULL)
    {
        AxisAlignedSlice4DViewerEnginePluginInfo::clientAtts  = new AxisAlignedSlice4DAttributes;
        AxisAlignedSlice4DViewerEnginePluginInfo::defaultAtts = new AxisAlignedSlice4DAttributes;
    }
}

// ****************************************************************************
//  Method: AxisAlignedSlice4DViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
AxisAlignedSlice4DViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: AxisAlignedSlice4DViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
AxisAlignedSlice4DViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: AxisAlignedSlice4DViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
AxisAlignedSlice4DViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(AxisAlignedSlice4DAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: AxisAlignedSlice4DViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
AxisAlignedSlice4DViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(AxisAlignedSlice4DAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: AxisAlignedSlice4DViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
AxisAlignedSlice4DViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(AxisAlignedSlice4DAttributes*)atts = *defaultAtts;
    else
        *(AxisAlignedSlice4DAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: AxisAlignedSlice4DViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
AxisAlignedSlice4DViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: AxisAlignedSlice4DViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
AxisAlignedSlice4DViewerEnginePluginInfo::GetMenuName() const
{
    return "Axis Aligned Slice 4D";
}

