// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: AxisAlignedSlice4DPluginInfo.h
// ****************************************************************************

#ifndef AXISALIGNEDSLICE4D_PLUGIN_INFO_H
#define AXISALIGNEDSLICE4D_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class AxisAlignedSlice4DAttributes;

// ****************************************************************************
//  Class: AxisAlignedSlice4DPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an AxisAlignedSlice4D operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class AxisAlignedSlice4DGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class AxisAlignedSlice4DCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual AxisAlignedSlice4DGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
    virtual ExpressionList *GetCreatedExpressions(const avtDatabaseMetaData *) const;
};

class AxisAlignedSlice4DGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual AxisAlignedSlice4DCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class AxisAlignedSlice4DViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual AxisAlignedSlice4DCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static AxisAlignedSlice4DAttributes *defaultAtts;
    static AxisAlignedSlice4DAttributes *clientAtts;
};

class AxisAlignedSlice4DViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual AxisAlignedSlice4DViewerEnginePluginInfo
{
  public:
};

class AxisAlignedSlice4DEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual AxisAlignedSlice4DViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class AxisAlignedSlice4DScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual AxisAlignedSlice4DCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
