// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import java.lang.Integer;
import java.util.Vector;

// ****************************************************************************
// Class: AxisAlignedSlice4DAttributes
//
// Purpose:
//    Attributes for AxisAlignedSlice4D
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class AxisAlignedSlice4DAttributes extends AttributeSubject implements Plugin
{
    private static int AxisAlignedSlice4DAttributes_numAdditionalAtts = 4;

    public AxisAlignedSlice4DAttributes()
    {
        super(AxisAlignedSlice4DAttributes_numAdditionalAtts);

        I = new Vector();
        J = new Vector();
        K = new Vector();
        L = new Vector();
    }

    public AxisAlignedSlice4DAttributes(int nMoreFields)
    {
        super(AxisAlignedSlice4DAttributes_numAdditionalAtts + nMoreFields);

        I = new Vector();
        J = new Vector();
        K = new Vector();
        L = new Vector();
    }

    public AxisAlignedSlice4DAttributes(AxisAlignedSlice4DAttributes obj)
    {
        super(obj);

        int i;

        I = new Vector();
        for(i = 0; i < obj.I.size(); ++i)
        {
            Integer iv = (Integer)obj.I.elementAt(i);
            I.addElement(new Integer(iv.intValue()));
        }
        J = new Vector();
        for(i = 0; i < obj.J.size(); ++i)
        {
            Integer iv = (Integer)obj.J.elementAt(i);
            J.addElement(new Integer(iv.intValue()));
        }
        K = new Vector();
        for(i = 0; i < obj.K.size(); ++i)
        {
            Integer iv = (Integer)obj.K.elementAt(i);
            K.addElement(new Integer(iv.intValue()));
        }
        L = new Vector();
        for(i = 0; i < obj.L.size(); ++i)
        {
            Integer iv = (Integer)obj.L.elementAt(i);
            L.addElement(new Integer(iv.intValue()));
        }

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return AxisAlignedSlice4DAttributes_numAdditionalAtts;
    }

    public boolean equals(AxisAlignedSlice4DAttributes obj)
    {
        int i;

        // Compare the elements in the I vector.
        boolean I_equal = (obj.I.size() == I.size());
        for(i = 0; (i < I.size()) && I_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer I1 = (Integer)I.elementAt(i);
            Integer I2 = (Integer)obj.I.elementAt(i);
            I_equal = I1.equals(I2);
        }
        // Compare the elements in the J vector.
        boolean J_equal = (obj.J.size() == J.size());
        for(i = 0; (i < J.size()) && J_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer J1 = (Integer)J.elementAt(i);
            Integer J2 = (Integer)obj.J.elementAt(i);
            J_equal = J1.equals(J2);
        }
        // Compare the elements in the K vector.
        boolean K_equal = (obj.K.size() == K.size());
        for(i = 0; (i < K.size()) && K_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer K1 = (Integer)K.elementAt(i);
            Integer K2 = (Integer)obj.K.elementAt(i);
            K_equal = K1.equals(K2);
        }
        // Compare the elements in the L vector.
        boolean L_equal = (obj.L.size() == L.size());
        for(i = 0; (i < L.size()) && L_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer L1 = (Integer)L.elementAt(i);
            Integer L2 = (Integer)obj.L.elementAt(i);
            L_equal = L1.equals(L2);
        }
        // Create the return value
        return (I_equal &&
                J_equal &&
                K_equal &&
                L_equal);
    }

    public String GetName() { return "AxisAlignedSlice4D"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetI(Vector I_)
    {
        I = I_;
        Select(0);
    }

    public void SetJ(Vector J_)
    {
        J = J_;
        Select(1);
    }

    public void SetK(Vector K_)
    {
        K = K_;
        Select(2);
    }

    public void SetL(Vector L_)
    {
        L = L_;
        Select(3);
    }

    // Property getting methods
    public Vector GetI() { return I; }
    public Vector GetJ() { return J; }
    public Vector GetK() { return K; }
    public Vector GetL() { return L; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteIntVector(I);
        if(WriteSelect(1, buf))
            buf.WriteIntVector(J);
        if(WriteSelect(2, buf))
            buf.WriteIntVector(K);
        if(WriteSelect(3, buf))
            buf.WriteIntVector(L);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetI(buf.ReadIntVector());
            break;
        case 1:
            SetJ(buf.ReadIntVector());
            break;
        case 2:
            SetK(buf.ReadIntVector());
            break;
        case 3:
            SetL(buf.ReadIntVector());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intVectorToString("I", I, indent) + "\n";
        str = str + intVectorToString("J", J, indent) + "\n";
        str = str + intVectorToString("K", K, indent) + "\n";
        str = str + intVectorToString("L", L, indent) + "\n";
        return str;
    }


    // Attributes
    private Vector I; // vector of Integer objects
    private Vector J; // vector of Integer objects
    private Vector K; // vector of Integer objects
    private Vector L; // vector of Integer objects
}

