// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISAMRSTITCHCELLWINDOW_H
#define QVISAMRSTITCHCELLWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class AMRStitchCellAttributes;
class QLabel;
class QButtonGroup;

// ****************************************************************************
// Class: QvisAMRStitchCellWindow
//
// Purpose:
//    Defines QvisAMRStitchCellWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisAMRStitchCellWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisAMRStitchCellWindow(const int type,
                         AMRStitchCellAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisAMRStitchCellWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void CreateCellsOfTypeChanged(int val);
  private:
    QWidget      *CreateCellsOfType;
    QButtonGroup *CreateCellsOfTypeButtonGroup;
    QLabel *CreateCellsOfTypeLabel;

    AMRStitchCellAttributes *atts;
};



#endif
