// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisAMRStitchCellWindow.h"

#include <AMRStitchCellAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QButtonGroup>
#include <QRadioButton>


// ****************************************************************************
// Method: QvisAMRStitchCellWindow::QvisAMRStitchCellWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisAMRStitchCellWindow::QvisAMRStitchCellWindow(const int type,
                         AMRStitchCellAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisAMRStitchCellWindow::~QvisAMRStitchCellWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisAMRStitchCellWindow::~QvisAMRStitchCellWindow()
{
}


// ****************************************************************************
// Method: QvisAMRStitchCellWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisAMRStitchCellWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    CreateCellsOfTypeLabel = new QLabel(tr("Create cells of type"), central);
    mainLayout->addWidget(CreateCellsOfTypeLabel,0,0);
    CreateCellsOfType = new QWidget(central);
    CreateCellsOfTypeButtonGroup= new QButtonGroup(CreateCellsOfType);
    QHBoxLayout *CreateCellsOfTypeLayout = new QHBoxLayout(CreateCellsOfType);
    CreateCellsOfTypeLayout->setMargin(0);
    CreateCellsOfTypeLayout->setSpacing(10);
    QRadioButton *CreateCellsOfTypeCreateTypeDualGridAndStitchCells = new QRadioButton(tr("DualGridAndStitchCells"), CreateCellsOfType);
    CreateCellsOfTypeButtonGroup->addButton(CreateCellsOfTypeCreateTypeDualGridAndStitchCells,0);
    CreateCellsOfTypeLayout->addWidget(CreateCellsOfTypeCreateTypeDualGridAndStitchCells);
    QRadioButton *CreateCellsOfTypeCreateTypeDualGrid = new QRadioButton(tr("DualGrid"), CreateCellsOfType);
    CreateCellsOfTypeButtonGroup->addButton(CreateCellsOfTypeCreateTypeDualGrid,1);
    CreateCellsOfTypeLayout->addWidget(CreateCellsOfTypeCreateTypeDualGrid);
    QRadioButton *CreateCellsOfTypeCreateTypeStitchCells = new QRadioButton(tr("StitchCells"), CreateCellsOfType);
    CreateCellsOfTypeButtonGroup->addButton(CreateCellsOfTypeCreateTypeStitchCells,2);
    CreateCellsOfTypeLayout->addWidget(CreateCellsOfTypeCreateTypeStitchCells);
    connect(CreateCellsOfTypeButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(CreateCellsOfTypeChanged(int)));
    mainLayout->addWidget(CreateCellsOfType, 0,1);

}


// ****************************************************************************
// Method: QvisAMRStitchCellWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisAMRStitchCellWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case AMRStitchCellAttributes::ID_CreateCellsOfType:
            CreateCellsOfTypeButtonGroup->blockSignals(true);
            if(CreateCellsOfTypeButtonGroup->button((int)atts->GetCreateCellsOfType()) != 0)
                CreateCellsOfTypeButtonGroup->button((int)atts->GetCreateCellsOfType())->setChecked(true);
            CreateCellsOfTypeButtonGroup->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisAMRStitchCellWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisAMRStitchCellWindow::GetCurrentValues(int which_widget)
{
}


//
// Qt Slot functions
//


void
QvisAMRStitchCellWindow::CreateCellsOfTypeChanged(int val)
{
    if(val != atts->GetCreateCellsOfType())
    {
        atts->SetCreateCellsOfType(AMRStitchCellAttributes::CreateType(val));
        SetUpdate(false);
        Apply();
    }
}


