// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: AMRStitchCellViewerEnginePluginInfo.C
// ****************************************************************************

#include <AMRStitchCellPluginInfo.h>
#include <AMRStitchCellAttributes.h>

//
// Storage for static data elements.
//
AMRStitchCellAttributes *AMRStitchCellViewerEnginePluginInfo::clientAtts = NULL;
AMRStitchCellAttributes *AMRStitchCellViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  AMRStitchCellViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
AMRStitchCellViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (AMRStitchCellViewerEnginePluginInfo::clientAtts == NULL)
    {
        AMRStitchCellViewerEnginePluginInfo::clientAtts  = new AMRStitchCellAttributes;
        AMRStitchCellViewerEnginePluginInfo::defaultAtts = new AMRStitchCellAttributes;
    }
}

// ****************************************************************************
//  Method: AMRStitchCellViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
AMRStitchCellViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: AMRStitchCellViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
AMRStitchCellViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: AMRStitchCellViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
AMRStitchCellViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(AMRStitchCellAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: AMRStitchCellViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
AMRStitchCellViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(AMRStitchCellAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: AMRStitchCellViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
AMRStitchCellViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(AMRStitchCellAttributes*)atts = *defaultAtts;
    else
        *(AMRStitchCellAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: AMRStitchCellViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
AMRStitchCellViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: AMRStitchCellViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
AMRStitchCellViewerEnginePluginInfo::GetMenuName() const
{
    return "AMR Dual Grid and Stitch Cells";
}

