// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  AMRStitchCellScriptingPluginInfo.C
// ************************************************************************* //
#include <PyAMRStitchCellAttributes.h>
#include <AMRStitchCellPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(AMRStitchCell,Scripting)

// ****************************************************************************
// Method: AMRStitchCellScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
AMRStitchCellScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyAMRStitchCellAttributes_StartUp((AMRStitchCellAttributes *)subj, data);
}

// ****************************************************************************
// Method: AMRStitchCellScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
AMRStitchCellScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyAMRStitchCellAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: AMRStitchCellScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is AMRStitchCell plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AMRStitchCellScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyAMRStitchCellAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: AMRStitchCellScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
AMRStitchCellScriptingPluginInfo::GetLogString()
{
    std::string s(PyAMRStitchCellAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: AMRStitchCellScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
AMRStitchCellScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyAMRStitchCellAttributes_SetDefaults((const AMRStitchCellAttributes *)atts);
}
