// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <AMRStitchCellAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for AMRStitchCellAttributes::CreateType
//

static const char *CreateType_strings[] = {
"DualGridAndStitchCells", "DualGrid", "StitchCells"
};

std::string
AMRStitchCellAttributes::CreateType_ToString(AMRStitchCellAttributes::CreateType t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return CreateType_strings[index];
}

std::string
AMRStitchCellAttributes::CreateType_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return CreateType_strings[index];
}

bool
AMRStitchCellAttributes::CreateType_FromString(const std::string &s, AMRStitchCellAttributes::CreateType &val)
{
    val = AMRStitchCellAttributes::DualGridAndStitchCells;
    for(int i = 0; i < 3; ++i)
    {
        if(s == CreateType_strings[i])
        {
            val = (CreateType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::AMRStitchCellAttributes
//
// Purpose:
//   Init utility for the AMRStitchCellAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void AMRStitchCellAttributes::Init()
{
    CreateCellsOfType = DualGridAndStitchCells;

    AMRStitchCellAttributes::SelectAll();
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::AMRStitchCellAttributes
//
// Purpose:
//   Copy utility for the AMRStitchCellAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void AMRStitchCellAttributes::Copy(const AMRStitchCellAttributes &obj)
{
    CreateCellsOfType = obj.CreateCellsOfType;

    AMRStitchCellAttributes::SelectAll();
}

// Type map format string
const char *AMRStitchCellAttributes::TypeMapFormatString = AMRSTITCHCELLATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t AMRStitchCellAttributes::TmfsStruct = {AMRSTITCHCELLATTRIBUTES_TMFS};


// ****************************************************************************
// Method: AMRStitchCellAttributes::AMRStitchCellAttributes
//
// Purpose:
//   Default constructor for the AMRStitchCellAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AMRStitchCellAttributes::AMRStitchCellAttributes() :
    AttributeSubject(AMRStitchCellAttributes::TypeMapFormatString)
{
    AMRStitchCellAttributes::Init();
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::AMRStitchCellAttributes
//
// Purpose:
//   Constructor for the derived classes of AMRStitchCellAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AMRStitchCellAttributes::AMRStitchCellAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    AMRStitchCellAttributes::Init();
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::AMRStitchCellAttributes
//
// Purpose:
//   Copy constructor for the AMRStitchCellAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AMRStitchCellAttributes::AMRStitchCellAttributes(const AMRStitchCellAttributes &obj) :
    AttributeSubject(AMRStitchCellAttributes::TypeMapFormatString)
{
    AMRStitchCellAttributes::Copy(obj);
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::AMRStitchCellAttributes
//
// Purpose:
//   Copy constructor for derived classes of the AMRStitchCellAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AMRStitchCellAttributes::AMRStitchCellAttributes(const AMRStitchCellAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    AMRStitchCellAttributes::Copy(obj);
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::~AMRStitchCellAttributes
//
// Purpose:
//   Destructor for the AMRStitchCellAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AMRStitchCellAttributes::~AMRStitchCellAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::operator =
//
// Purpose:
//   Assignment operator for the AMRStitchCellAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AMRStitchCellAttributes&
AMRStitchCellAttributes::operator = (const AMRStitchCellAttributes &obj)
{
    if (this == &obj) return *this;

    AMRStitchCellAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the AMRStitchCellAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AMRStitchCellAttributes::operator == (const AMRStitchCellAttributes &obj) const
{
    // Create the return value
    return ((CreateCellsOfType == obj.CreateCellsOfType));
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the AMRStitchCellAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AMRStitchCellAttributes::operator != (const AMRStitchCellAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::TypeName
//
// Purpose:
//   Type name method for the AMRStitchCellAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
AMRStitchCellAttributes::TypeName() const
{
    return "AMRStitchCellAttributes";
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the AMRStitchCellAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AMRStitchCellAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AMRStitchCellAttributes *tmp = (const AMRStitchCellAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the AMRStitchCellAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
AMRStitchCellAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AMRStitchCellAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the AMRStitchCellAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
AMRStitchCellAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AMRStitchCellAttributes(*this);
    else
        retval = new AMRStitchCellAttributes;

    return retval;
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
AMRStitchCellAttributes::SelectAll()
{
    Select(ID_CreateCellsOfType, (void *)&CreateCellsOfType);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AMRStitchCellAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AMRStitchCellAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AMRStitchCellAttributes defaultObject;
    bool addToParent = false;
    // Create a node for AMRStitchCellAttributes.
    DataNode *node = new DataNode("AMRStitchCellAttributes");

    if(completeSave || !FieldsEqual(ID_CreateCellsOfType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("CreateCellsOfType", CreateType_ToString(CreateCellsOfType)));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
AMRStitchCellAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AMRStitchCellAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("CreateCellsOfType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetCreateCellsOfType(CreateType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            CreateType value;
            if(CreateType_FromString(node->AsString(), value))
                SetCreateCellsOfType(value);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
AMRStitchCellAttributes::SetCreateCellsOfType(AMRStitchCellAttributes::CreateType CreateCellsOfType_)
{
    CreateCellsOfType = CreateCellsOfType_;
    Select(ID_CreateCellsOfType, (void *)&CreateCellsOfType);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

AMRStitchCellAttributes::CreateType
AMRStitchCellAttributes::GetCreateCellsOfType() const
{
    return CreateType(CreateCellsOfType);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AMRStitchCellAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
AMRStitchCellAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_CreateCellsOfType: return "CreateCellsOfType";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
AMRStitchCellAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_CreateCellsOfType: return FieldType_enum;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
AMRStitchCellAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_CreateCellsOfType: return "enum";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AMRStitchCellAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AMRStitchCellAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const AMRStitchCellAttributes &obj = *((const AMRStitchCellAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_CreateCellsOfType:
        {  // new scope
        retval = (CreateCellsOfType == obj.CreateCellsOfType);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

