// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;


// ****************************************************************************
// Class: avtVectorMetaData
//
// Purpose:
//    Contains vector metadata attributes
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class avtVectorMetaData extends avtVarMetaData
{
    private static int avtVectorMetaData_numAdditionalAtts = 1;

    public avtVectorMetaData()
    {
        super(avtVectorMetaData_numAdditionalAtts);

        varDim = 0;
    }

    public avtVectorMetaData(int nMoreFields)
    {
        super(avtVectorMetaData_numAdditionalAtts + nMoreFields);

        varDim = 0;
    }

    public avtVectorMetaData(avtVectorMetaData obj)
    {
        super(obj);

        varDim = obj.varDim;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return avtVectorMetaData_numAdditionalAtts;
    }

    public boolean equals(avtVectorMetaData obj)
    {
        // Create the return value
        return (super.equals(obj) && (varDim == obj.varDim));
    }

    // Property setting methods
    public void SetVarDim(int varDim_)
    {
        varDim = varDim_;
        Select((new avtVectorMetaData()).Offset() + 0);
    }

    // Property getting methods
    public int GetVarDim() { return varDim; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        super.WriteAtts(buf);

        int offset = (new avtVectorMetaData()).Offset();
        if(WriteSelect(offset + 0, buf))
            buf.WriteInt(varDim);
    }

    public void ReadAtts(int id, CommunicationBuffer buf)
    {
        int offset = (new avtVectorMetaData()).Offset();
        if(id == offset)
            SetVarDim(buf.ReadInt());
        else
            super.ReadAtts(id, buf);
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intToString("varDim", varDim, indent) + "\n";
        return super.toString(indent) + str;
    }


    // Attributes
    private int varDim;
}

