// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;


// ****************************************************************************
// Class: avtTensorMetaData
//
// Purpose:
//    Contains tensor metadata attributes
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class avtTensorMetaData extends avtVarMetaData
{
    private static int avtTensorMetaData_numAdditionalAtts = 1;

    public avtTensorMetaData()
    {
        super(avtTensorMetaData_numAdditionalAtts);

        dim = 0;
    }

    public avtTensorMetaData(int nMoreFields)
    {
        super(avtTensorMetaData_numAdditionalAtts + nMoreFields);

        dim = 0;
    }

    public avtTensorMetaData(avtTensorMetaData obj)
    {
        super(obj);

        dim = obj.dim;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return avtTensorMetaData_numAdditionalAtts;
    }

    public boolean equals(avtTensorMetaData obj)
    {
        // Create the return value
        return (super.equals(obj) && (dim == obj.dim));
    }

    // Property setting methods
    public void SetDim(int dim_)
    {
        dim = dim_;
        Select((new avtTensorMetaData()).Offset() + 0);
    }

    // Property getting methods
    public int GetDim() { return dim; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        super.WriteAtts(buf);

        int offset = (new avtTensorMetaData()).Offset();
        if(WriteSelect(offset + 0, buf))
            buf.WriteInt(dim);
    }

    public void ReadAtts(int id, CommunicationBuffer buf)
    {
        int offset = (new avtTensorMetaData()).Offset();
        if(id == offset)
            SetDim(buf.ReadInt());
        else
            super.ReadAtts(id, buf);
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intToString("dim", dim, indent) + "\n";
        return super.toString(indent) + str;
    }


    // Attributes
    private int dim;
}

