// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;

import java.util.Vector;
import java.lang.Integer;

// ****************************************************************************
// Class: avtMeshMetaData
//
// Purpose:
//    Contains mesh metadata attributes
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class avtMeshMetaData extends AttributeSubject
{
    private static int avtMeshMetaData_numAdditionalAtts = 52;

    public avtMeshMetaData()
    {
        super(avtMeshMetaData_numAdditionalAtts);

        name = new String("mesh");
        originalName = new String("");
        validVariable = true;
        meshType = 0;
        meshCoordType = 0;
        cellOrigin = 0;
        spatialDimension = 3;
        hasLogicalBounds = false;
        logicalBounds = new int[3];
        logicalBounds[0] = 0;
        logicalBounds[1] = 0;
        logicalBounds[2] = 0;
        hasNumberCells = false;
        numberCells = 0;
        topologicalDimension = 3;
        xUnits = new String("");
        yUnits = new String("");
        zUnits = new String("");
        xLabel = new String("X-Axis");
        yLabel = new String("Y-Axis");
        zLabel = new String("Z-Axis");
        hasSpatialExtents = false;
        minSpatialExtents = new double[3];
        minSpatialExtents[0] = 0;
        minSpatialExtents[1] = 0;
        minSpatialExtents[2] = 0;
        maxSpatialExtents = new double[3];
        maxSpatialExtents[0] = 0;
        maxSpatialExtents[1] = 0;
        maxSpatialExtents[2] = 0;
        numBlocks = 1;
        blockOrigin = 0;
        blockPieceName = new String("domain");
        blockTitle = new String("domains");
        blockNames = new Vector();
        blockNameScheme = new NameschemeAttributes();
        numGroups = 0;
        groupOrigin = 0;
        groupPieceName = new String("group");
        groupTitle = new String("groups");
        groupNames = new Vector();
        groupIds = new Vector();
        groupIdsBasedOnRange = new Vector();
        disjointElements = false;
        containsGhostZones = 0;
        containsOriginalCells = false;
        containsOriginalNodes = false;
        containsGlobalNodeIds = false;
        containsGlobalZoneIds = false;
        loadBalanceScheme = 0;
        nodesAreCritical = false;
        unitCellVectors = new float[9];
        unitCellVectors[0] = 1f;
        unitCellVectors[1] = 0f;
        unitCellVectors[2] = 0f;
        unitCellVectors[3] = 0f;
        unitCellVectors[4] = 1f;
        unitCellVectors[5] = 0f;
        unitCellVectors[6] = 0f;
        unitCellVectors[7] = 0f;
        unitCellVectors[8] = 1f;
        unitCellOrigin = new float[3];
        unitCellOrigin[0] = 0f;
        unitCellOrigin[1] = 0f;
        unitCellOrigin[2] = 0f;
        rectilinearGridHasTransform = false;
        rectilinearGridTransform = new double[16];
        rectilinearGridTransform[0] = 1;
        rectilinearGridTransform[1] = 0;
        rectilinearGridTransform[2] = 0;
        rectilinearGridTransform[3] = 0;
        rectilinearGridTransform[4] = 0;
        rectilinearGridTransform[5] = 1;
        rectilinearGridTransform[6] = 0;
        rectilinearGridTransform[7] = 0;
        rectilinearGridTransform[8] = 0;
        rectilinearGridTransform[9] = 0;
        rectilinearGridTransform[10] = 1;
        rectilinearGridTransform[11] = 0;
        rectilinearGridTransform[12] = 0;
        rectilinearGridTransform[13] = 0;
        rectilinearGridTransform[14] = 0;
        rectilinearGridTransform[15] = 1;
        nodeOrigin = 0;
        containsExteriorBoundaryGhosts = false;
        hideFromGUI = false;
        LODs = 1;
        presentGhostZoneTypes = 0;
        zonesWereSplit = false;
    }

    public avtMeshMetaData(int nMoreFields)
    {
        super(avtMeshMetaData_numAdditionalAtts + nMoreFields);

        name = new String("mesh");
        originalName = new String("");
        validVariable = true;
        meshType = 0;
        meshCoordType = 0;
        cellOrigin = 0;
        spatialDimension = 3;
        hasLogicalBounds = false;
        logicalBounds = new int[3];
        logicalBounds[0] = 0;
        logicalBounds[1] = 0;
        logicalBounds[2] = 0;
        hasNumberCells = false;
        numberCells = 0;
        topologicalDimension = 3;
        xUnits = new String("");
        yUnits = new String("");
        zUnits = new String("");
        xLabel = new String("X-Axis");
        yLabel = new String("Y-Axis");
        zLabel = new String("Z-Axis");
        hasSpatialExtents = false;
        minSpatialExtents = new double[3];
        minSpatialExtents[0] = 0;
        minSpatialExtents[1] = 0;
        minSpatialExtents[2] = 0;
        maxSpatialExtents = new double[3];
        maxSpatialExtents[0] = 0;
        maxSpatialExtents[1] = 0;
        maxSpatialExtents[2] = 0;
        numBlocks = 1;
        blockOrigin = 0;
        blockPieceName = new String("domain");
        blockTitle = new String("domains");
        blockNames = new Vector();
        blockNameScheme = new NameschemeAttributes();
        numGroups = 0;
        groupOrigin = 0;
        groupPieceName = new String("group");
        groupTitle = new String("groups");
        groupNames = new Vector();
        groupIds = new Vector();
        groupIdsBasedOnRange = new Vector();
        disjointElements = false;
        containsGhostZones = 0;
        containsOriginalCells = false;
        containsOriginalNodes = false;
        containsGlobalNodeIds = false;
        containsGlobalZoneIds = false;
        loadBalanceScheme = 0;
        nodesAreCritical = false;
        unitCellVectors = new float[9];
        unitCellVectors[0] = 1f;
        unitCellVectors[1] = 0f;
        unitCellVectors[2] = 0f;
        unitCellVectors[3] = 0f;
        unitCellVectors[4] = 1f;
        unitCellVectors[5] = 0f;
        unitCellVectors[6] = 0f;
        unitCellVectors[7] = 0f;
        unitCellVectors[8] = 1f;
        unitCellOrigin = new float[3];
        unitCellOrigin[0] = 0f;
        unitCellOrigin[1] = 0f;
        unitCellOrigin[2] = 0f;
        rectilinearGridHasTransform = false;
        rectilinearGridTransform = new double[16];
        rectilinearGridTransform[0] = 1;
        rectilinearGridTransform[1] = 0;
        rectilinearGridTransform[2] = 0;
        rectilinearGridTransform[3] = 0;
        rectilinearGridTransform[4] = 0;
        rectilinearGridTransform[5] = 1;
        rectilinearGridTransform[6] = 0;
        rectilinearGridTransform[7] = 0;
        rectilinearGridTransform[8] = 0;
        rectilinearGridTransform[9] = 0;
        rectilinearGridTransform[10] = 1;
        rectilinearGridTransform[11] = 0;
        rectilinearGridTransform[12] = 0;
        rectilinearGridTransform[13] = 0;
        rectilinearGridTransform[14] = 0;
        rectilinearGridTransform[15] = 1;
        nodeOrigin = 0;
        containsExteriorBoundaryGhosts = false;
        hideFromGUI = false;
        LODs = 1;
        presentGhostZoneTypes = 0;
        zonesWereSplit = false;
    }

    public avtMeshMetaData(avtMeshMetaData obj)
    {
        super(obj);

        int i;

        name = new String(obj.name);
        originalName = new String(obj.originalName);
        validVariable = obj.validVariable;
        meshType = obj.meshType;
        meshCoordType = obj.meshCoordType;
        cellOrigin = obj.cellOrigin;
        spatialDimension = obj.spatialDimension;
        hasLogicalBounds = obj.hasLogicalBounds;
        logicalBounds = new int[3];
        logicalBounds[0] = obj.logicalBounds[0];
        logicalBounds[1] = obj.logicalBounds[1];
        logicalBounds[2] = obj.logicalBounds[2];

        hasNumberCells = obj.hasNumberCells;
        numberCells = obj.numberCells;
        topologicalDimension = obj.topologicalDimension;
        xUnits = new String(obj.xUnits);
        yUnits = new String(obj.yUnits);
        zUnits = new String(obj.zUnits);
        xLabel = new String(obj.xLabel);
        yLabel = new String(obj.yLabel);
        zLabel = new String(obj.zLabel);
        hasSpatialExtents = obj.hasSpatialExtents;
        minSpatialExtents = new double[3];
        minSpatialExtents[0] = obj.minSpatialExtents[0];
        minSpatialExtents[1] = obj.minSpatialExtents[1];
        minSpatialExtents[2] = obj.minSpatialExtents[2];

        maxSpatialExtents = new double[3];
        maxSpatialExtents[0] = obj.maxSpatialExtents[0];
        maxSpatialExtents[1] = obj.maxSpatialExtents[1];
        maxSpatialExtents[2] = obj.maxSpatialExtents[2];

        numBlocks = obj.numBlocks;
        blockOrigin = obj.blockOrigin;
        blockPieceName = new String(obj.blockPieceName);
        blockTitle = new String(obj.blockTitle);
        blockNames = new Vector(obj.blockNames.size());
        for(i = 0; i < obj.blockNames.size(); ++i)
            blockNames.addElement(new String((String)obj.blockNames.elementAt(i)));

        blockNameScheme = new NameschemeAttributes(obj.blockNameScheme);
        numGroups = obj.numGroups;
        groupOrigin = obj.groupOrigin;
        groupPieceName = new String(obj.groupPieceName);
        groupTitle = new String(obj.groupTitle);
        groupNames = new Vector(obj.groupNames.size());
        for(i = 0; i < obj.groupNames.size(); ++i)
            groupNames.addElement(new String((String)obj.groupNames.elementAt(i)));

        groupIds = new Vector();
        for(i = 0; i < obj.groupIds.size(); ++i)
        {
            Integer iv = (Integer)obj.groupIds.elementAt(i);
            groupIds.addElement(new Integer(iv.intValue()));
        }
        groupIdsBasedOnRange = new Vector();
        for(i = 0; i < obj.groupIdsBasedOnRange.size(); ++i)
        {
            Integer iv = (Integer)obj.groupIdsBasedOnRange.elementAt(i);
            groupIdsBasedOnRange.addElement(new Integer(iv.intValue()));
        }
        disjointElements = obj.disjointElements;
        containsGhostZones = obj.containsGhostZones;
        containsOriginalCells = obj.containsOriginalCells;
        containsOriginalNodes = obj.containsOriginalNodes;
        containsGlobalNodeIds = obj.containsGlobalNodeIds;
        containsGlobalZoneIds = obj.containsGlobalZoneIds;
        loadBalanceScheme = obj.loadBalanceScheme;
        nodesAreCritical = obj.nodesAreCritical;
        unitCellVectors = new float[9];
        for(i = 0; i < obj.unitCellVectors.length; ++i)
            unitCellVectors[i] = obj.unitCellVectors[i];

        unitCellOrigin = new float[3];
        unitCellOrigin[0] = obj.unitCellOrigin[0];
        unitCellOrigin[1] = obj.unitCellOrigin[1];
        unitCellOrigin[2] = obj.unitCellOrigin[2];

        rectilinearGridHasTransform = obj.rectilinearGridHasTransform;
        rectilinearGridTransform = new double[16];
        for(i = 0; i < obj.rectilinearGridTransform.length; ++i)
            rectilinearGridTransform[i] = obj.rectilinearGridTransform[i];

        nodeOrigin = obj.nodeOrigin;
        containsExteriorBoundaryGhosts = obj.containsExteriorBoundaryGhosts;
        hideFromGUI = obj.hideFromGUI;
        LODs = obj.LODs;
        presentGhostZoneTypes = obj.presentGhostZoneTypes;
        zonesWereSplit = obj.zonesWereSplit;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return avtMeshMetaData_numAdditionalAtts;
    }

    public boolean equals(avtMeshMetaData obj)
    {
        int i;

        // Compare the logicalBounds arrays.
        boolean logicalBounds_equal = true;
        for(i = 0; i < 3 && logicalBounds_equal; ++i)
            logicalBounds_equal = (logicalBounds[i] == obj.logicalBounds[i]);

        // Compare the minSpatialExtents arrays.
        boolean minSpatialExtents_equal = true;
        for(i = 0; i < 3 && minSpatialExtents_equal; ++i)
            minSpatialExtents_equal = (minSpatialExtents[i] == obj.minSpatialExtents[i]);

        // Compare the maxSpatialExtents arrays.
        boolean maxSpatialExtents_equal = true;
        for(i = 0; i < 3 && maxSpatialExtents_equal; ++i)
            maxSpatialExtents_equal = (maxSpatialExtents[i] == obj.maxSpatialExtents[i]);

        // Compare the elements in the blockNames vector.
        boolean blockNames_equal = (obj.blockNames.size() == blockNames.size());
        for(i = 0; (i < blockNames.size()) && blockNames_equal; ++i)
        {
            // Make references to String from Object.
            String blockNames1 = (String)blockNames.elementAt(i);
            String blockNames2 = (String)obj.blockNames.elementAt(i);
            blockNames_equal = blockNames1.equals(blockNames2);
        }
        // Compare the elements in the groupNames vector.
        boolean groupNames_equal = (obj.groupNames.size() == groupNames.size());
        for(i = 0; (i < groupNames.size()) && groupNames_equal; ++i)
        {
            // Make references to String from Object.
            String groupNames1 = (String)groupNames.elementAt(i);
            String groupNames2 = (String)obj.groupNames.elementAt(i);
            groupNames_equal = groupNames1.equals(groupNames2);
        }
        // Compare the elements in the groupIds vector.
        boolean groupIds_equal = (obj.groupIds.size() == groupIds.size());
        for(i = 0; (i < groupIds.size()) && groupIds_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer groupIds1 = (Integer)groupIds.elementAt(i);
            Integer groupIds2 = (Integer)obj.groupIds.elementAt(i);
            groupIds_equal = groupIds1.equals(groupIds2);
        }
        // Compare the elements in the groupIdsBasedOnRange vector.
        boolean groupIdsBasedOnRange_equal = (obj.groupIdsBasedOnRange.size() == groupIdsBasedOnRange.size());
        for(i = 0; (i < groupIdsBasedOnRange.size()) && groupIdsBasedOnRange_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer groupIdsBasedOnRange1 = (Integer)groupIdsBasedOnRange.elementAt(i);
            Integer groupIdsBasedOnRange2 = (Integer)obj.groupIdsBasedOnRange.elementAt(i);
            groupIdsBasedOnRange_equal = groupIdsBasedOnRange1.equals(groupIdsBasedOnRange2);
        }
        // Compare the unitCellVectors arrays.
        boolean unitCellVectors_equal = true;
        for(i = 0; i < 9 && unitCellVectors_equal; ++i)
            unitCellVectors_equal = (unitCellVectors[i] == obj.unitCellVectors[i]);

        // Compare the unitCellOrigin arrays.
        boolean unitCellOrigin_equal = true;
        for(i = 0; i < 3 && unitCellOrigin_equal; ++i)
            unitCellOrigin_equal = (unitCellOrigin[i] == obj.unitCellOrigin[i]);

        // Compare the rectilinearGridTransform arrays.
        boolean rectilinearGridTransform_equal = true;
        for(i = 0; i < 16 && rectilinearGridTransform_equal; ++i)
            rectilinearGridTransform_equal = (rectilinearGridTransform[i] == obj.rectilinearGridTransform[i]);

        // Create the return value
        return ((name.equals(obj.name)) &&
                (originalName.equals(obj.originalName)) &&
                (validVariable == obj.validVariable) &&
                (meshType == obj.meshType) &&
                (meshCoordType == obj.meshCoordType) &&
                (cellOrigin == obj.cellOrigin) &&
                (spatialDimension == obj.spatialDimension) &&
                (hasLogicalBounds == obj.hasLogicalBounds) &&
                logicalBounds_equal &&
                (hasNumberCells == obj.hasNumberCells) &&
                (numberCells == obj.numberCells) &&
                (topologicalDimension == obj.topologicalDimension) &&
                (xUnits.equals(obj.xUnits)) &&
                (yUnits.equals(obj.yUnits)) &&
                (zUnits.equals(obj.zUnits)) &&
                (xLabel.equals(obj.xLabel)) &&
                (yLabel.equals(obj.yLabel)) &&
                (zLabel.equals(obj.zLabel)) &&
                (hasSpatialExtents == obj.hasSpatialExtents) &&
                minSpatialExtents_equal &&
                maxSpatialExtents_equal &&
                (numBlocks == obj.numBlocks) &&
                (blockOrigin == obj.blockOrigin) &&
                (blockPieceName.equals(obj.blockPieceName)) &&
                (blockTitle.equals(obj.blockTitle)) &&
                blockNames_equal &&
                (blockNameScheme.equals(obj.blockNameScheme)) &&
                (numGroups == obj.numGroups) &&
                (groupOrigin == obj.groupOrigin) &&
                (groupPieceName.equals(obj.groupPieceName)) &&
                (groupTitle.equals(obj.groupTitle)) &&
                groupNames_equal &&
                groupIds_equal &&
                groupIdsBasedOnRange_equal &&
                (disjointElements == obj.disjointElements) &&
                (containsGhostZones == obj.containsGhostZones) &&
                (containsOriginalCells == obj.containsOriginalCells) &&
                (containsOriginalNodes == obj.containsOriginalNodes) &&
                (containsGlobalNodeIds == obj.containsGlobalNodeIds) &&
                (containsGlobalZoneIds == obj.containsGlobalZoneIds) &&
                (loadBalanceScheme == obj.loadBalanceScheme) &&
                (nodesAreCritical == obj.nodesAreCritical) &&
                unitCellVectors_equal &&
                unitCellOrigin_equal &&
                (rectilinearGridHasTransform == obj.rectilinearGridHasTransform) &&
                rectilinearGridTransform_equal &&
                (nodeOrigin == obj.nodeOrigin) &&
                (containsExteriorBoundaryGhosts == obj.containsExteriorBoundaryGhosts) &&
                (hideFromGUI == obj.hideFromGUI) &&
                (LODs == obj.LODs) &&
                (presentGhostZoneTypes == obj.presentGhostZoneTypes) &&
                (zonesWereSplit == obj.zonesWereSplit));
    }

    // Property setting methods
    public void SetName(String name_)
    {
        name = name_;
        Select(0);
    }

    public void SetOriginalName(String originalName_)
    {
        originalName = originalName_;
        Select(1);
    }

    public void SetValidVariable(boolean validVariable_)
    {
        validVariable = validVariable_;
        Select(2);
    }

    public void SetMeshType(int meshType_)
    {
        meshType = meshType_;
        Select(3);
    }

    public void SetMeshCoordType(int meshCoordType_)
    {
        meshCoordType = meshCoordType_;
        Select(4);
    }

    public void SetCellOrigin(int cellOrigin_)
    {
        cellOrigin = cellOrigin_;
        Select(5);
    }

    public void SetSpatialDimension(int spatialDimension_)
    {
        spatialDimension = spatialDimension_;
        Select(6);
    }

    public void SetHasLogicalBounds(boolean hasLogicalBounds_)
    {
        hasLogicalBounds = hasLogicalBounds_;
        Select(7);
    }

    public void SetLogicalBounds(int[] logicalBounds_)
    {
        logicalBounds[0] = logicalBounds_[0];
        logicalBounds[1] = logicalBounds_[1];
        logicalBounds[2] = logicalBounds_[2];
        Select(8);
    }

    public void SetLogicalBounds(int e0, int e1, int e2)
    {
        logicalBounds[0] = e0;
        logicalBounds[1] = e1;
        logicalBounds[2] = e2;
        Select(8);
    }

    public void SetHasNumberCells(boolean hasNumberCells_)
    {
        hasNumberCells = hasNumberCells_;
        Select(9);
    }

    public void SetNumberCells(int numberCells_)
    {
        numberCells = numberCells_;
        Select(10);
    }

    public void SetTopologicalDimension(int topologicalDimension_)
    {
        topologicalDimension = topologicalDimension_;
        Select(11);
    }

    public void SetXUnits(String xUnits_)
    {
        xUnits = xUnits_;
        Select(12);
    }

    public void SetYUnits(String yUnits_)
    {
        yUnits = yUnits_;
        Select(13);
    }

    public void SetZUnits(String zUnits_)
    {
        zUnits = zUnits_;
        Select(14);
    }

    public void SetXLabel(String xLabel_)
    {
        xLabel = xLabel_;
        Select(15);
    }

    public void SetYLabel(String yLabel_)
    {
        yLabel = yLabel_;
        Select(16);
    }

    public void SetZLabel(String zLabel_)
    {
        zLabel = zLabel_;
        Select(17);
    }

    public void SetHasSpatialExtents(boolean hasSpatialExtents_)
    {
        hasSpatialExtents = hasSpatialExtents_;
        Select(18);
    }

    public void SetMinSpatialExtents(double[] minSpatialExtents_)
    {
        minSpatialExtents[0] = minSpatialExtents_[0];
        minSpatialExtents[1] = minSpatialExtents_[1];
        minSpatialExtents[2] = minSpatialExtents_[2];
        Select(19);
    }

    public void SetMinSpatialExtents(double e0, double e1, double e2)
    {
        minSpatialExtents[0] = e0;
        minSpatialExtents[1] = e1;
        minSpatialExtents[2] = e2;
        Select(19);
    }

    public void SetMaxSpatialExtents(double[] maxSpatialExtents_)
    {
        maxSpatialExtents[0] = maxSpatialExtents_[0];
        maxSpatialExtents[1] = maxSpatialExtents_[1];
        maxSpatialExtents[2] = maxSpatialExtents_[2];
        Select(20);
    }

    public void SetMaxSpatialExtents(double e0, double e1, double e2)
    {
        maxSpatialExtents[0] = e0;
        maxSpatialExtents[1] = e1;
        maxSpatialExtents[2] = e2;
        Select(20);
    }

    public void SetNumBlocks(int numBlocks_)
    {
        numBlocks = numBlocks_;
        Select(21);
    }

    public void SetBlockOrigin(int blockOrigin_)
    {
        blockOrigin = blockOrigin_;
        Select(22);
    }

    public void SetBlockPieceName(String blockPieceName_)
    {
        blockPieceName = blockPieceName_;
        Select(23);
    }

    public void SetBlockTitle(String blockTitle_)
    {
        blockTitle = blockTitle_;
        Select(24);
    }

    public void SetBlockNames(Vector blockNames_)
    {
        blockNames = blockNames_;
        Select(25);
    }

    public void SetBlockNameScheme(NameschemeAttributes blockNameScheme_)
    {
        blockNameScheme = blockNameScheme_;
        Select(26);
    }

    public void SetNumGroups(int numGroups_)
    {
        numGroups = numGroups_;
        Select(27);
    }

    public void SetGroupOrigin(int groupOrigin_)
    {
        groupOrigin = groupOrigin_;
        Select(28);
    }

    public void SetGroupPieceName(String groupPieceName_)
    {
        groupPieceName = groupPieceName_;
        Select(29);
    }

    public void SetGroupTitle(String groupTitle_)
    {
        groupTitle = groupTitle_;
        Select(30);
    }

    public void SetGroupNames(Vector groupNames_)
    {
        groupNames = groupNames_;
        Select(31);
    }

    public void SetGroupIds(Vector groupIds_)
    {
        groupIds = groupIds_;
        Select(32);
    }

    public void SetGroupIdsBasedOnRange(Vector groupIdsBasedOnRange_)
    {
        groupIdsBasedOnRange = groupIdsBasedOnRange_;
        Select(33);
    }

    public void SetDisjointElements(boolean disjointElements_)
    {
        disjointElements = disjointElements_;
        Select(34);
    }

    public void SetContainsGhostZones(int containsGhostZones_)
    {
        containsGhostZones = containsGhostZones_;
        Select(35);
    }

    public void SetContainsOriginalCells(boolean containsOriginalCells_)
    {
        containsOriginalCells = containsOriginalCells_;
        Select(36);
    }

    public void SetContainsOriginalNodes(boolean containsOriginalNodes_)
    {
        containsOriginalNodes = containsOriginalNodes_;
        Select(37);
    }

    public void SetContainsGlobalNodeIds(boolean containsGlobalNodeIds_)
    {
        containsGlobalNodeIds = containsGlobalNodeIds_;
        Select(38);
    }

    public void SetContainsGlobalZoneIds(boolean containsGlobalZoneIds_)
    {
        containsGlobalZoneIds = containsGlobalZoneIds_;
        Select(39);
    }

    public void SetLoadBalanceScheme(int loadBalanceScheme_)
    {
        loadBalanceScheme = loadBalanceScheme_;
        Select(40);
    }

    public void SetNodesAreCritical(boolean nodesAreCritical_)
    {
        nodesAreCritical = nodesAreCritical_;
        Select(41);
    }

    public void SetUnitCellVectors(float[] unitCellVectors_)
    {
        for(int i = 0; i < 9; ++i)
             unitCellVectors[i] = unitCellVectors_[i];
        Select(42);
    }

    public void SetUnitCellOrigin(float[] unitCellOrigin_)
    {
        unitCellOrigin[0] = unitCellOrigin_[0];
        unitCellOrigin[1] = unitCellOrigin_[1];
        unitCellOrigin[2] = unitCellOrigin_[2];
        Select(43);
    }

    public void SetUnitCellOrigin(float e0, float e1, float e2)
    {
        unitCellOrigin[0] = e0;
        unitCellOrigin[1] = e1;
        unitCellOrigin[2] = e2;
        Select(43);
    }

    public void SetRectilinearGridHasTransform(boolean rectilinearGridHasTransform_)
    {
        rectilinearGridHasTransform = rectilinearGridHasTransform_;
        Select(44);
    }

    public void SetRectilinearGridTransform(double[] rectilinearGridTransform_)
    {
        for(int i = 0; i < 16; ++i)
             rectilinearGridTransform[i] = rectilinearGridTransform_[i];
        Select(45);
    }

    public void SetNodeOrigin(int nodeOrigin_)
    {
        nodeOrigin = nodeOrigin_;
        Select(46);
    }

    public void SetContainsExteriorBoundaryGhosts(boolean containsExteriorBoundaryGhosts_)
    {
        containsExteriorBoundaryGhosts = containsExteriorBoundaryGhosts_;
        Select(47);
    }

    public void SetHideFromGUI(boolean hideFromGUI_)
    {
        hideFromGUI = hideFromGUI_;
        Select(48);
    }

    public void SetLODs(int LODs_)
    {
        LODs = LODs_;
        Select(49);
    }

    public void SetPresentGhostZoneTypes(int presentGhostZoneTypes_)
    {
        presentGhostZoneTypes = presentGhostZoneTypes_;
        Select(50);
    }

    public void SetZonesWereSplit(boolean zonesWereSplit_)
    {
        zonesWereSplit = zonesWereSplit_;
        Select(51);
    }

    // Property getting methods
    public String               GetName() { return name; }
    public String               GetOriginalName() { return originalName; }
    public boolean              GetValidVariable() { return validVariable; }
    public int                  GetMeshType() { return meshType; }
    public int                  GetMeshCoordType() { return meshCoordType; }
    public int                  GetCellOrigin() { return cellOrigin; }
    public int                  GetSpatialDimension() { return spatialDimension; }
    public boolean              GetHasLogicalBounds() { return hasLogicalBounds; }
    public int[]                GetLogicalBounds() { return logicalBounds; }
    public boolean              GetHasNumberCells() { return hasNumberCells; }
    public int                  GetNumberCells() { return numberCells; }
    public int                  GetTopologicalDimension() { return topologicalDimension; }
    public String               GetXUnits() { return xUnits; }
    public String               GetYUnits() { return yUnits; }
    public String               GetZUnits() { return zUnits; }
    public String               GetXLabel() { return xLabel; }
    public String               GetYLabel() { return yLabel; }
    public String               GetZLabel() { return zLabel; }
    public boolean              GetHasSpatialExtents() { return hasSpatialExtents; }
    public double[]             GetMinSpatialExtents() { return minSpatialExtents; }
    public double[]             GetMaxSpatialExtents() { return maxSpatialExtents; }
    public int                  GetNumBlocks() { return numBlocks; }
    public int                  GetBlockOrigin() { return blockOrigin; }
    public String               GetBlockPieceName() { return blockPieceName; }
    public String               GetBlockTitle() { return blockTitle; }
    public Vector               GetBlockNames() { return blockNames; }
    public NameschemeAttributes GetBlockNameScheme() { return blockNameScheme; }
    public int                  GetNumGroups() { return numGroups; }
    public int                  GetGroupOrigin() { return groupOrigin; }
    public String               GetGroupPieceName() { return groupPieceName; }
    public String               GetGroupTitle() { return groupTitle; }
    public Vector               GetGroupNames() { return groupNames; }
    public Vector               GetGroupIds() { return groupIds; }
    public Vector               GetGroupIdsBasedOnRange() { return groupIdsBasedOnRange; }
    public boolean              GetDisjointElements() { return disjointElements; }
    public int                  GetContainsGhostZones() { return containsGhostZones; }
    public boolean              GetContainsOriginalCells() { return containsOriginalCells; }
    public boolean              GetContainsOriginalNodes() { return containsOriginalNodes; }
    public boolean              GetContainsGlobalNodeIds() { return containsGlobalNodeIds; }
    public boolean              GetContainsGlobalZoneIds() { return containsGlobalZoneIds; }
    public int                  GetLoadBalanceScheme() { return loadBalanceScheme; }
    public boolean              GetNodesAreCritical() { return nodesAreCritical; }
    public float[]              GetUnitCellVectors() { return unitCellVectors; }
    public float[]              GetUnitCellOrigin() { return unitCellOrigin; }
    public boolean              GetRectilinearGridHasTransform() { return rectilinearGridHasTransform; }
    public double[]             GetRectilinearGridTransform() { return rectilinearGridTransform; }
    public int                  GetNodeOrigin() { return nodeOrigin; }
    public boolean              GetContainsExteriorBoundaryGhosts() { return containsExteriorBoundaryGhosts; }
    public boolean              GetHideFromGUI() { return hideFromGUI; }
    public int                  GetLODs() { return LODs; }
    public int                  GetPresentGhostZoneTypes() { return presentGhostZoneTypes; }
    public boolean              GetZonesWereSplit() { return zonesWereSplit; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteString(name);
        if(WriteSelect(1, buf))
            buf.WriteString(originalName);
        if(WriteSelect(2, buf))
            buf.WriteBool(validVariable);
        if(WriteSelect(3, buf))
            buf.WriteInt(meshType);
        if(WriteSelect(4, buf))
            buf.WriteInt(meshCoordType);
        if(WriteSelect(5, buf))
            buf.WriteInt(cellOrigin);
        if(WriteSelect(6, buf))
            buf.WriteInt(spatialDimension);
        if(WriteSelect(7, buf))
            buf.WriteBool(hasLogicalBounds);
        if(WriteSelect(8, buf))
            buf.WriteIntArray(logicalBounds);
        if(WriteSelect(9, buf))
            buf.WriteBool(hasNumberCells);
        if(WriteSelect(10, buf))
            buf.WriteInt(numberCells);
        if(WriteSelect(11, buf))
            buf.WriteInt(topologicalDimension);
        if(WriteSelect(12, buf))
            buf.WriteString(xUnits);
        if(WriteSelect(13, buf))
            buf.WriteString(yUnits);
        if(WriteSelect(14, buf))
            buf.WriteString(zUnits);
        if(WriteSelect(15, buf))
            buf.WriteString(xLabel);
        if(WriteSelect(16, buf))
            buf.WriteString(yLabel);
        if(WriteSelect(17, buf))
            buf.WriteString(zLabel);
        if(WriteSelect(18, buf))
            buf.WriteBool(hasSpatialExtents);
        if(WriteSelect(19, buf))
            buf.WriteDoubleArray(minSpatialExtents);
        if(WriteSelect(20, buf))
            buf.WriteDoubleArray(maxSpatialExtents);
        if(WriteSelect(21, buf))
            buf.WriteInt(numBlocks);
        if(WriteSelect(22, buf))
            buf.WriteInt(blockOrigin);
        if(WriteSelect(23, buf))
            buf.WriteString(blockPieceName);
        if(WriteSelect(24, buf))
            buf.WriteString(blockTitle);
        if(WriteSelect(25, buf))
            buf.WriteStringVector(blockNames);
        if(WriteSelect(26, buf))
            blockNameScheme.Write(buf);
        if(WriteSelect(27, buf))
            buf.WriteInt(numGroups);
        if(WriteSelect(28, buf))
            buf.WriteInt(groupOrigin);
        if(WriteSelect(29, buf))
            buf.WriteString(groupPieceName);
        if(WriteSelect(30, buf))
            buf.WriteString(groupTitle);
        if(WriteSelect(31, buf))
            buf.WriteStringVector(groupNames);
        if(WriteSelect(32, buf))
            buf.WriteIntVector(groupIds);
        if(WriteSelect(33, buf))
            buf.WriteIntVector(groupIdsBasedOnRange);
        if(WriteSelect(34, buf))
            buf.WriteBool(disjointElements);
        if(WriteSelect(35, buf))
            buf.WriteInt(containsGhostZones);
        if(WriteSelect(36, buf))
            buf.WriteBool(containsOriginalCells);
        if(WriteSelect(37, buf))
            buf.WriteBool(containsOriginalNodes);
        if(WriteSelect(38, buf))
            buf.WriteBool(containsGlobalNodeIds);
        if(WriteSelect(39, buf))
            buf.WriteBool(containsGlobalZoneIds);
        if(WriteSelect(40, buf))
            buf.WriteInt(loadBalanceScheme);
        if(WriteSelect(41, buf))
            buf.WriteBool(nodesAreCritical);
        if(WriteSelect(42, buf))
            buf.WriteFloatArray(unitCellVectors);
        if(WriteSelect(43, buf))
            buf.WriteFloatArray(unitCellOrigin);
        if(WriteSelect(44, buf))
            buf.WriteBool(rectilinearGridHasTransform);
        if(WriteSelect(45, buf))
            buf.WriteDoubleArray(rectilinearGridTransform);
        if(WriteSelect(46, buf))
            buf.WriteInt(nodeOrigin);
        if(WriteSelect(47, buf))
            buf.WriteBool(containsExteriorBoundaryGhosts);
        if(WriteSelect(48, buf))
            buf.WriteBool(hideFromGUI);
        if(WriteSelect(49, buf))
            buf.WriteInt(LODs);
        if(WriteSelect(50, buf))
            buf.WriteInt(presentGhostZoneTypes);
        if(WriteSelect(51, buf))
            buf.WriteBool(zonesWereSplit);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetName(buf.ReadString());
            break;
        case 1:
            SetOriginalName(buf.ReadString());
            break;
        case 2:
            SetValidVariable(buf.ReadBool());
            break;
        case 3:
            SetMeshType(buf.ReadInt());
            break;
        case 4:
            SetMeshCoordType(buf.ReadInt());
            break;
        case 5:
            SetCellOrigin(buf.ReadInt());
            break;
        case 6:
            SetSpatialDimension(buf.ReadInt());
            break;
        case 7:
            SetHasLogicalBounds(buf.ReadBool());
            break;
        case 8:
            SetLogicalBounds(buf.ReadIntArray());
            break;
        case 9:
            SetHasNumberCells(buf.ReadBool());
            break;
        case 10:
            SetNumberCells(buf.ReadInt());
            break;
        case 11:
            SetTopologicalDimension(buf.ReadInt());
            break;
        case 12:
            SetXUnits(buf.ReadString());
            break;
        case 13:
            SetYUnits(buf.ReadString());
            break;
        case 14:
            SetZUnits(buf.ReadString());
            break;
        case 15:
            SetXLabel(buf.ReadString());
            break;
        case 16:
            SetYLabel(buf.ReadString());
            break;
        case 17:
            SetZLabel(buf.ReadString());
            break;
        case 18:
            SetHasSpatialExtents(buf.ReadBool());
            break;
        case 19:
            SetMinSpatialExtents(buf.ReadDoubleArray());
            break;
        case 20:
            SetMaxSpatialExtents(buf.ReadDoubleArray());
            break;
        case 21:
            SetNumBlocks(buf.ReadInt());
            break;
        case 22:
            SetBlockOrigin(buf.ReadInt());
            break;
        case 23:
            SetBlockPieceName(buf.ReadString());
            break;
        case 24:
            SetBlockTitle(buf.ReadString());
            break;
        case 25:
            SetBlockNames(buf.ReadStringVector());
            break;
        case 26:
            blockNameScheme.Read(buf);
            Select(26);
            break;
        case 27:
            SetNumGroups(buf.ReadInt());
            break;
        case 28:
            SetGroupOrigin(buf.ReadInt());
            break;
        case 29:
            SetGroupPieceName(buf.ReadString());
            break;
        case 30:
            SetGroupTitle(buf.ReadString());
            break;
        case 31:
            SetGroupNames(buf.ReadStringVector());
            break;
        case 32:
            SetGroupIds(buf.ReadIntVector());
            break;
        case 33:
            SetGroupIdsBasedOnRange(buf.ReadIntVector());
            break;
        case 34:
            SetDisjointElements(buf.ReadBool());
            break;
        case 35:
            SetContainsGhostZones(buf.ReadInt());
            break;
        case 36:
            SetContainsOriginalCells(buf.ReadBool());
            break;
        case 37:
            SetContainsOriginalNodes(buf.ReadBool());
            break;
        case 38:
            SetContainsGlobalNodeIds(buf.ReadBool());
            break;
        case 39:
            SetContainsGlobalZoneIds(buf.ReadBool());
            break;
        case 40:
            SetLoadBalanceScheme(buf.ReadInt());
            break;
        case 41:
            SetNodesAreCritical(buf.ReadBool());
            break;
        case 42:
            SetUnitCellVectors(buf.ReadFloatArray());
            break;
        case 43:
            SetUnitCellOrigin(buf.ReadFloatArray());
            break;
        case 44:
            SetRectilinearGridHasTransform(buf.ReadBool());
            break;
        case 45:
            SetRectilinearGridTransform(buf.ReadDoubleArray());
            break;
        case 46:
            SetNodeOrigin(buf.ReadInt());
            break;
        case 47:
            SetContainsExteriorBoundaryGhosts(buf.ReadBool());
            break;
        case 48:
            SetHideFromGUI(buf.ReadBool());
            break;
        case 49:
            SetLODs(buf.ReadInt());
            break;
        case 50:
            SetPresentGhostZoneTypes(buf.ReadInt());
            break;
        case 51:
            SetZonesWereSplit(buf.ReadBool());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + stringToString("name", name, indent) + "\n";
        str = str + stringToString("originalName", originalName, indent) + "\n";
        str = str + boolToString("validVariable", validVariable, indent) + "\n";
        str = str + intToString("meshType", meshType, indent) + "\n";
        str = str + intToString("meshCoordType", meshCoordType, indent) + "\n";
        str = str + intToString("cellOrigin", cellOrigin, indent) + "\n";
        str = str + intToString("spatialDimension", spatialDimension, indent) + "\n";
        str = str + boolToString("hasLogicalBounds", hasLogicalBounds, indent) + "\n";
        str = str + intArrayToString("logicalBounds", logicalBounds, indent) + "\n";
        str = str + boolToString("hasNumberCells", hasNumberCells, indent) + "\n";
        str = str + intToString("numberCells", numberCells, indent) + "\n";
        str = str + intToString("topologicalDimension", topologicalDimension, indent) + "\n";
        str = str + stringToString("xUnits", xUnits, indent) + "\n";
        str = str + stringToString("yUnits", yUnits, indent) + "\n";
        str = str + stringToString("zUnits", zUnits, indent) + "\n";
        str = str + stringToString("xLabel", xLabel, indent) + "\n";
        str = str + stringToString("yLabel", yLabel, indent) + "\n";
        str = str + stringToString("zLabel", zLabel, indent) + "\n";
        str = str + boolToString("hasSpatialExtents", hasSpatialExtents, indent) + "\n";
        str = str + doubleArrayToString("minSpatialExtents", minSpatialExtents, indent) + "\n";
        str = str + doubleArrayToString("maxSpatialExtents", maxSpatialExtents, indent) + "\n";
        str = str + intToString("numBlocks", numBlocks, indent) + "\n";
        str = str + intToString("blockOrigin", blockOrigin, indent) + "\n";
        str = str + stringToString("blockPieceName", blockPieceName, indent) + "\n";
        str = str + stringToString("blockTitle", blockTitle, indent) + "\n";
        str = str + stringVectorToString("blockNames", blockNames, indent) + "\n";
        str = str + indent + "blockNameScheme = {\n" + blockNameScheme.toString(indent + "    ") + indent + "}\n";
        str = str + intToString("numGroups", numGroups, indent) + "\n";
        str = str + intToString("groupOrigin", groupOrigin, indent) + "\n";
        str = str + stringToString("groupPieceName", groupPieceName, indent) + "\n";
        str = str + stringToString("groupTitle", groupTitle, indent) + "\n";
        str = str + stringVectorToString("groupNames", groupNames, indent) + "\n";
        str = str + intVectorToString("groupIds", groupIds, indent) + "\n";
        str = str + intVectorToString("groupIdsBasedOnRange", groupIdsBasedOnRange, indent) + "\n";
        str = str + boolToString("disjointElements", disjointElements, indent) + "\n";
        str = str + intToString("containsGhostZones", containsGhostZones, indent) + "\n";
        str = str + boolToString("containsOriginalCells", containsOriginalCells, indent) + "\n";
        str = str + boolToString("containsOriginalNodes", containsOriginalNodes, indent) + "\n";
        str = str + boolToString("containsGlobalNodeIds", containsGlobalNodeIds, indent) + "\n";
        str = str + boolToString("containsGlobalZoneIds", containsGlobalZoneIds, indent) + "\n";
        str = str + intToString("loadBalanceScheme", loadBalanceScheme, indent) + "\n";
        str = str + boolToString("nodesAreCritical", nodesAreCritical, indent) + "\n";
        str = str + floatArrayToString("unitCellVectors", unitCellVectors, indent) + "\n";
        str = str + floatArrayToString("unitCellOrigin", unitCellOrigin, indent) + "\n";
        str = str + boolToString("rectilinearGridHasTransform", rectilinearGridHasTransform, indent) + "\n";
        str = str + doubleArrayToString("rectilinearGridTransform", rectilinearGridTransform, indent) + "\n";
        str = str + intToString("nodeOrigin", nodeOrigin, indent) + "\n";
        str = str + boolToString("containsExteriorBoundaryGhosts", containsExteriorBoundaryGhosts, indent) + "\n";
        str = str + boolToString("hideFromGUI", hideFromGUI, indent) + "\n";
        str = str + intToString("LODs", LODs, indent) + "\n";
        str = str + intToString("presentGhostZoneTypes", presentGhostZoneTypes, indent) + "\n";
        str = str + boolToString("zonesWereSplit", zonesWereSplit, indent) + "\n";
        return str;
    }


    // Attributes
    private String               name;
    private String               originalName;
    private boolean              validVariable;
    private int                  meshType;
    private int                  meshCoordType;
    private int                  cellOrigin;
    private int                  spatialDimension;
    private boolean              hasLogicalBounds;
    private int[]                logicalBounds;
    private boolean              hasNumberCells;
    private int                  numberCells;
    private int                  topologicalDimension;
    private String               xUnits;
    private String               yUnits;
    private String               zUnits;
    private String               xLabel;
    private String               yLabel;
    private String               zLabel;
    private boolean              hasSpatialExtents;
    private double[]             minSpatialExtents;
    private double[]             maxSpatialExtents;
    private int                  numBlocks;
    private int                  blockOrigin;
    private String               blockPieceName;
    private String               blockTitle;
    private Vector               blockNames; // vector of String objects
    private NameschemeAttributes blockNameScheme;
    private int                  numGroups;
    private int                  groupOrigin;
    private String               groupPieceName;
    private String               groupTitle;
    private Vector               groupNames; // vector of String objects
    private Vector               groupIds; // vector of Integer objects
    private Vector               groupIdsBasedOnRange; // vector of Integer objects
    private boolean              disjointElements;
    private int                  containsGhostZones;
    private boolean              containsOriginalCells;
    private boolean              containsOriginalNodes;
    private boolean              containsGlobalNodeIds;
    private boolean              containsGlobalZoneIds;
    private int                  loadBalanceScheme;
    private boolean              nodesAreCritical;
    private float[]              unitCellVectors;
    private float[]              unitCellOrigin;
    private boolean              rectilinearGridHasTransform;
    private double[]             rectilinearGridTransform;
    private int                  nodeOrigin;
    private boolean              containsExteriorBoundaryGhosts;
    private boolean              hideFromGUI;
    private int                  LODs;
    private int                  presentGhostZoneTypes;
    private boolean              zonesWereSplit;
}

