// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <stdio.h>
#include <string>

// ****************************************************************************
// Function: main
//
// Purpose:
//   Writes out a Java class that contains VisIt's version number. The class
//   is autogenerated so we don't have to keep doing it by hand.
//
// Notes:      
//
// Programmer: Brad Whitlock
// Creation:   Wed Aug 21 12:24:23 PDT 2002
//
// Modifications:
//   Brad Whitlock, Thu Nov 19 16:44:51 PST 2009
//   Get the input and output file from the command line.
//
// ****************************************************************************

int
main(int argc, char *argv[])
{
    FILE *fp = NULL;
    int i, reached_end = 0, retval = 1;

    if(argc != 3)
    {
        fprintf(stderr, "Usage: %s versionfile outputfile\n", argv[0]);
        return -1;
    }

    std::string ver("2.0");
    if((fp = fopen(argv[1], "rt")) != NULL)
    {
        char s[2] = {'\0', '\0'};
        ver = "";
        while(!feof(fp))
        {
            s[0] = (char)fgetc(fp);
            if(s[0] != '\n')
                ver += s;
            else
                break;
        }
        fclose(fp);
    }
        
    // Open the file and write the Java class.
    if((fp = fopen(argv[2], "wt")) != NULL)
    {
        printf("Writing Version.java\n");
        fprintf(fp, "package llnl.visit;\n");
        fprintf(fp, "\n");
        fprintf(fp, "// ****************************************************************************\n");
        fprintf(fp, "// Class: Version\n");
        fprintf(fp, "//\n");
        fprintf(fp, "// Purpose:\n");
        fprintf(fp, "//   This automatically generated class contains VisIt's version.\n");
        fprintf(fp, "//\n");
        fprintf(fp, "// ****************************************************************************\n");
        fprintf(fp, "\n");
        fprintf(fp, "public class Version\n");
        fprintf(fp, "{\n");
        fprintf(fp, "    public final static byte[] version = {");

        // Print the characters of the version string.
        for(i = 0; i < 10; ++i)
        {
            if(reached_end)
                fprintf(fp, "'\\0'");
            else if(ver[i] == '\0')
            {
                reached_end = 1;
                fprintf(fp, "'\\0'");
            }
            else
                fprintf(fp, "'%c'", ver[i]);

            if(i < 9)
                fprintf(fp, ", ");
        }

        fprintf(fp, "};\n");
        fprintf(fp, "}\n");
        fprintf(fp, "\n");
        fclose(fp);
        retval = 0;
    }

    return retval;
}
