// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;


// ****************************************************************************
// Class: SelectionVariableSummary
//
// Purpose:
//    Contains a summary of a variable used in a selection
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class SelectionVariableSummary extends AttributeSubject
{
    private static int SelectionVariableSummary_numAdditionalAtts = 4;

    public SelectionVariableSummary()
    {
        super(SelectionVariableSummary_numAdditionalAtts);

        name = new String("");
        minimum = 0;
        maximum = 0;
        histogram = new double[256];
        for (int i = 0; i < histogram.length; ++i)
            histogram[i] = 0.;
    }

    public SelectionVariableSummary(int nMoreFields)
    {
        super(SelectionVariableSummary_numAdditionalAtts + nMoreFields);

        name = new String("");
        minimum = 0;
        maximum = 0;
        histogram = new double[256];
        for (int i = 0; i < histogram.length; ++i)
            histogram[i] = 0.;
    }

    public SelectionVariableSummary(SelectionVariableSummary obj)
    {
        super(obj);

        int i;

        name = new String(obj.name);
        minimum = obj.minimum;
        maximum = obj.maximum;
        histogram = new double[256];
        for(i = 0; i < obj.histogram.length; ++i)
            histogram[i] = obj.histogram[i];


        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return SelectionVariableSummary_numAdditionalAtts;
    }

    public boolean equals(SelectionVariableSummary obj)
    {
        int i;

        // Compare the histogram arrays.
        boolean histogram_equal = true;
        for(i = 0; i < 256 && histogram_equal; ++i)
            histogram_equal = (histogram[i] == obj.histogram[i]);

        // Create the return value
        return ((name.equals(obj.name)) &&
                (minimum == obj.minimum) &&
                (maximum == obj.maximum) &&
                histogram_equal);
    }

    // Property setting methods
    public void SetName(String name_)
    {
        name = name_;
        Select(0);
    }

    public void SetMinimum(double minimum_)
    {
        minimum = minimum_;
        Select(1);
    }

    public void SetMaximum(double maximum_)
    {
        maximum = maximum_;
        Select(2);
    }

    public void SetHistogram(double[] histogram_)
    {
        for(int i = 0; i < 256; ++i)
             histogram[i] = histogram_[i];
        Select(3);
    }

    // Property getting methods
    public String   GetName() { return name; }
    public double   GetMinimum() { return minimum; }
    public double   GetMaximum() { return maximum; }
    public double[] GetHistogram() { return histogram; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteString(name);
        if(WriteSelect(1, buf))
            buf.WriteDouble(minimum);
        if(WriteSelect(2, buf))
            buf.WriteDouble(maximum);
        if(WriteSelect(3, buf))
            buf.WriteDoubleArray(histogram);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetName(buf.ReadString());
            break;
        case 1:
            SetMinimum(buf.ReadDouble());
            break;
        case 2:
            SetMaximum(buf.ReadDouble());
            break;
        case 3:
            SetHistogram(buf.ReadDoubleArray());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + stringToString("name", name, indent) + "\n";
        str = str + doubleToString("minimum", minimum, indent) + "\n";
        str = str + doubleToString("maximum", maximum, indent) + "\n";
        str = str + doubleArrayToString("histogram", histogram, indent) + "\n";
        return str;
    }


    // Attributes
    private String   name;
    private double   minimum;
    private double   maximum;
    private double[] histogram;
}

