// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;

import java.lang.Integer;
import java.util.Vector;
import java.lang.Double;

// ****************************************************************************
// Class: ProcessAttributes
//
// Purpose:
//    attributes to describe a running process
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class ProcessAttributes extends AttributeSubject
{
    private static int ProcessAttributes_numAdditionalAtts = 6;

    public ProcessAttributes()
    {
        super(ProcessAttributes_numAdditionalAtts);

        pids = new Vector();
        ppids = new Vector();
        hosts = new Vector();
        isParallel = false;
        memory = new Vector();
        times = new Vector();
    }

    public ProcessAttributes(int nMoreFields)
    {
        super(ProcessAttributes_numAdditionalAtts + nMoreFields);

        pids = new Vector();
        ppids = new Vector();
        hosts = new Vector();
        isParallel = false;
        memory = new Vector();
        times = new Vector();
    }

    public ProcessAttributes(ProcessAttributes obj)
    {
        super(obj);

        int i;

        pids = new Vector();
        for(i = 0; i < obj.pids.size(); ++i)
        {
            Integer iv = (Integer)obj.pids.elementAt(i);
            pids.addElement(new Integer(iv.intValue()));
        }
        ppids = new Vector();
        for(i = 0; i < obj.ppids.size(); ++i)
        {
            Integer iv = (Integer)obj.ppids.elementAt(i);
            ppids.addElement(new Integer(iv.intValue()));
        }
        hosts = new Vector(obj.hosts.size());
        for(i = 0; i < obj.hosts.size(); ++i)
            hosts.addElement(new String((String)obj.hosts.elementAt(i)));

        isParallel = obj.isParallel;
        memory = new Vector();
        for(i = 0; i < obj.memory.size(); ++i)
        {
            Integer iv = (Integer)obj.memory.elementAt(i);
            memory.addElement(new Integer(iv.intValue()));
        }
        times = new Vector(obj.times.size());
        for(i = 0; i < obj.times.size(); ++i)
        {
            Double dv = (Double)obj.times.elementAt(i);
            times.addElement(new Double(dv.doubleValue()));
        }


        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return ProcessAttributes_numAdditionalAtts;
    }

    public boolean equals(ProcessAttributes obj)
    {
        int i;

        // Compare the elements in the pids vector.
        boolean pids_equal = (obj.pids.size() == pids.size());
        for(i = 0; (i < pids.size()) && pids_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer pids1 = (Integer)pids.elementAt(i);
            Integer pids2 = (Integer)obj.pids.elementAt(i);
            pids_equal = pids1.equals(pids2);
        }
        // Compare the elements in the ppids vector.
        boolean ppids_equal = (obj.ppids.size() == ppids.size());
        for(i = 0; (i < ppids.size()) && ppids_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer ppids1 = (Integer)ppids.elementAt(i);
            Integer ppids2 = (Integer)obj.ppids.elementAt(i);
            ppids_equal = ppids1.equals(ppids2);
        }
        // Compare the elements in the hosts vector.
        boolean hosts_equal = (obj.hosts.size() == hosts.size());
        for(i = 0; (i < hosts.size()) && hosts_equal; ++i)
        {
            // Make references to String from Object.
            String hosts1 = (String)hosts.elementAt(i);
            String hosts2 = (String)obj.hosts.elementAt(i);
            hosts_equal = hosts1.equals(hosts2);
        }
        // Compare the elements in the memory vector.
        boolean memory_equal = (obj.memory.size() == memory.size());
        for(i = 0; (i < memory.size()) && memory_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer memory1 = (Integer)memory.elementAt(i);
            Integer memory2 = (Integer)obj.memory.elementAt(i);
            memory_equal = memory1.equals(memory2);
        }
        // Compare the elements in the times vector.
        boolean times_equal = (obj.times.size() == times.size());
        for(i = 0; (i < times.size()) && times_equal; ++i)
        {
            // Make references to Double from Object.
            Double times1 = (Double)times.elementAt(i);
            Double times2 = (Double)obj.times.elementAt(i);
            times_equal = times1.equals(times2);
        }
        // Create the return value
        return (pids_equal &&
                ppids_equal &&
                hosts_equal &&
                (isParallel == obj.isParallel) &&
                memory_equal &&
                times_equal);
    }

    // Property setting methods
    public void SetPids(Vector pids_)
    {
        pids = pids_;
        Select(0);
    }

    public void SetPpids(Vector ppids_)
    {
        ppids = ppids_;
        Select(1);
    }

    public void SetHosts(Vector hosts_)
    {
        hosts = hosts_;
        Select(2);
    }

    public void SetIsParallel(boolean isParallel_)
    {
        isParallel = isParallel_;
        Select(3);
    }

    public void SetMemory(Vector memory_)
    {
        memory = memory_;
        Select(4);
    }

    public void SetTimes(Vector times_)
    {
        times = times_;
        Select(5);
    }

    // Property getting methods
    public Vector  GetPids() { return pids; }
    public Vector  GetPpids() { return ppids; }
    public Vector  GetHosts() { return hosts; }
    public boolean GetIsParallel() { return isParallel; }
    public Vector  GetMemory() { return memory; }
    public Vector  GetTimes() { return times; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteIntVector(pids);
        if(WriteSelect(1, buf))
            buf.WriteIntVector(ppids);
        if(WriteSelect(2, buf))
            buf.WriteStringVector(hosts);
        if(WriteSelect(3, buf))
            buf.WriteBool(isParallel);
        if(WriteSelect(4, buf))
            buf.WriteIntVector(memory);
        if(WriteSelect(5, buf))
            buf.WriteDoubleVector(times);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetPids(buf.ReadIntVector());
            break;
        case 1:
            SetPpids(buf.ReadIntVector());
            break;
        case 2:
            SetHosts(buf.ReadStringVector());
            break;
        case 3:
            SetIsParallel(buf.ReadBool());
            break;
        case 4:
            SetMemory(buf.ReadIntVector());
            break;
        case 5:
            SetTimes(buf.ReadDoubleVector());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intVectorToString("pids", pids, indent) + "\n";
        str = str + intVectorToString("ppids", ppids, indent) + "\n";
        str = str + stringVectorToString("hosts", hosts, indent) + "\n";
        str = str + boolToString("isParallel", isParallel, indent) + "\n";
        str = str + intVectorToString("memory", memory, indent) + "\n";
        str = str + doubleVectorToString("times", times, indent) + "\n";
        return str;
    }


    // Attributes
    private Vector  pids; // vector of Integer objects
    private Vector  ppids; // vector of Integer objects
    private Vector  hosts; // vector of String objects
    private boolean isParallel;
    private Vector  memory; // vector of Integer objects
    private Vector  times; // vector of Double objects
}

