// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;

import java.lang.Integer;
import java.util.Vector;

// ****************************************************************************
// Class: NamespaceAttributes
//
// Purpose:
//    This class contain the information needed to represent a namespace.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class NamespaceAttributes extends AttributeSubject
{
    private static int NamespaceAttributes_numAdditionalAtts = 4;

    public NamespaceAttributes()
    {
        super(NamespaceAttributes_numAdditionalAtts);

        type = -1;
        subsets = new Vector();
        min = -1;
        max = -1;
    }

    public NamespaceAttributes(int nMoreFields)
    {
        super(NamespaceAttributes_numAdditionalAtts + nMoreFields);

        type = -1;
        subsets = new Vector();
        min = -1;
        max = -1;
    }

    public NamespaceAttributes(NamespaceAttributes obj)
    {
        super(obj);

        int i;

        type = obj.type;
        subsets = new Vector();
        for(i = 0; i < obj.subsets.size(); ++i)
        {
            Integer iv = (Integer)obj.subsets.elementAt(i);
            subsets.addElement(new Integer(iv.intValue()));
        }
        min = obj.min;
        max = obj.max;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return NamespaceAttributes_numAdditionalAtts;
    }

    public boolean equals(NamespaceAttributes obj)
    {
        int i;

        // Compare the elements in the subsets vector.
        boolean subsets_equal = (obj.subsets.size() == subsets.size());
        for(i = 0; (i < subsets.size()) && subsets_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer subsets1 = (Integer)subsets.elementAt(i);
            Integer subsets2 = (Integer)obj.subsets.elementAt(i);
            subsets_equal = subsets1.equals(subsets2);
        }
        // Create the return value
        return ((type == obj.type) &&
                subsets_equal &&
                (min == obj.min) &&
                (max == obj.max));
    }

    // Property setting methods
    public void SetType(int type_)
    {
        type = type_;
        Select(0);
    }

    public void SetSubsets(Vector subsets_)
    {
        subsets = subsets_;
        Select(1);
    }

    public void SetMin(int min_)
    {
        min = min_;
        Select(2);
    }

    public void SetMax(int max_)
    {
        max = max_;
        Select(3);
    }

    // Property getting methods
    public int    GetType() { return type; }
    public Vector GetSubsets() { return subsets; }
    public int    GetMin() { return min; }
    public int    GetMax() { return max; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(type);
        if(WriteSelect(1, buf))
            buf.WriteIntVector(subsets);
        if(WriteSelect(2, buf))
            buf.WriteInt(min);
        if(WriteSelect(3, buf))
            buf.WriteInt(max);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetType(buf.ReadInt());
            break;
        case 1:
            SetSubsets(buf.ReadIntVector());
            break;
        case 2:
            SetMin(buf.ReadInt());
            break;
        case 3:
            SetMax(buf.ReadInt());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intToString("type", type, indent) + "\n";
        str = str + intVectorToString("subsets", subsets, indent) + "\n";
        str = str + intToString("min", min, indent) + "\n";
        str = str + intToString("max", max, indent) + "\n";
        return str;
    }


    // Attributes
    private int    type;
    private Vector subsets; // vector of Integer objects
    private int    min;
    private int    max;
}

