// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;

import java.util.Vector;

// ****************************************************************************
// Class: GaussianControlPointList
//
// Purpose:
//    This class contains a list of GaussianControlPoint objects.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class GaussianControlPointList extends AttributeSubject
{
    private static int GaussianControlPointList_numAdditionalAtts = 1;

    public GaussianControlPointList()
    {
        super(GaussianControlPointList_numAdditionalAtts);

        controlPoints = new Vector();
    }

    public GaussianControlPointList(int nMoreFields)
    {
        super(GaussianControlPointList_numAdditionalAtts + nMoreFields);

        controlPoints = new Vector();
    }

    public GaussianControlPointList(GaussianControlPointList obj)
    {
        super(obj);

        int i;

        // *** Copy the controlPoints field ***
        controlPoints = new Vector(obj.controlPoints.size());
        for(i = 0; i < obj.controlPoints.size(); ++i)
        {
            GaussianControlPoint oldObj = (GaussianControlPoint)obj.controlPoints.elementAt(i);
            controlPoints.addElement(new GaussianControlPoint(oldObj));
        }


        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return GaussianControlPointList_numAdditionalAtts;
    }

    public boolean equals(GaussianControlPointList obj)
    {
        int i;

        // Compare the elements in the controlPoints vector.
        boolean controlPoints_equal = (obj.controlPoints.size() == controlPoints.size());
        for(i = 0; (i < controlPoints.size()) && controlPoints_equal; ++i)
        {
            // Make references to GaussianControlPoint from Object.
            GaussianControlPoint controlPoints1 = (GaussianControlPoint)controlPoints.elementAt(i);
            GaussianControlPoint controlPoints2 = (GaussianControlPoint)obj.controlPoints.elementAt(i);
            controlPoints_equal = controlPoints1.equals(controlPoints2);
        }
        // Create the return value
        return (controlPoints_equal);
    }

    // Property setting methods
    // Property getting methods
    public Vector GetControlPoints() { return controlPoints; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
        {
            buf.WriteInt(controlPoints.size());
            for(int i = 0; i < controlPoints.size(); ++i)
            {
                GaussianControlPoint tmp = (GaussianControlPoint)controlPoints.elementAt(i);
                tmp.Write(buf);
            }
        }
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        {
            int len = buf.ReadInt();
            controlPoints.clear();
            for(int j = 0; j < len; ++j)
            {
                GaussianControlPoint tmp = new GaussianControlPoint();
                tmp.Read(buf);
                controlPoints.addElement(tmp);
            }
        }
        Select(0);
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "controlPoints = {\n";
        for(int i = 0; i < controlPoints.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)controlPoints.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < controlPoints.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        return str;
    }

    // Attributegroup convenience methods
    public void AddControlPoints(GaussianControlPoint obj)
    {
        controlPoints.addElement(new GaussianControlPoint(obj));
        Select(0);
    }

    public void ClearControlPoints()
    {
        controlPoints.clear();
        Select(0);
    }

    public void RemoveControlPoints(int index)
    {
        if(index >= 0 && index < controlPoints.size())
        {
            controlPoints.remove(index);
            Select(0);
        }
    }

    public int GetNumControlPoints()
    {
        return controlPoints.size();
    }

    public GaussianControlPoint GetControlPoints(int i)
    {
        GaussianControlPoint tmp = (GaussianControlPoint)controlPoints.elementAt(i);
        return tmp;
    }


    // Attributes
    private Vector controlPoints; // vector of GaussianControlPoint objects
}

