// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;

import java.util.Vector;

// ****************************************************************************
// Class: ExpressionList
//
// Purpose:
//    This class contains a list of expressions and some functions to manipulate them.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class ExpressionList extends AttributeSubject
{
    private static int ExpressionList_numAdditionalAtts = 1;

    public ExpressionList()
    {
        super(ExpressionList_numAdditionalAtts);

        expressions = new Vector();
    }

    public ExpressionList(int nMoreFields)
    {
        super(ExpressionList_numAdditionalAtts + nMoreFields);

        expressions = new Vector();
    }

    public ExpressionList(ExpressionList obj)
    {
        super(obj);

        int i;

        // *** Copy the expressions field ***
        expressions = new Vector(obj.expressions.size());
        for(i = 0; i < obj.expressions.size(); ++i)
        {
            Expression oldObj = (Expression)obj.expressions.elementAt(i);
            expressions.addElement(new Expression(oldObj));
        }


        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return ExpressionList_numAdditionalAtts;
    }

    public boolean equals(ExpressionList obj)
    {
        int i;

        // Compare the elements in the expressions vector.
        boolean expressions_equal = (obj.expressions.size() == expressions.size());
        for(i = 0; (i < expressions.size()) && expressions_equal; ++i)
        {
            // Make references to Expression from Object.
            Expression expressions1 = (Expression)expressions.elementAt(i);
            Expression expressions2 = (Expression)obj.expressions.elementAt(i);
            expressions_equal = expressions1.equals(expressions2);
        }
        // Create the return value
        return (expressions_equal);
    }

    // Property setting methods
    // Property getting methods
    public Vector GetExpressions() { return expressions; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
        {
            buf.WriteInt(expressions.size());
            for(int i = 0; i < expressions.size(); ++i)
            {
                Expression tmp = (Expression)expressions.elementAt(i);
                tmp.Write(buf);
            }
        }
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        {
            int len = buf.ReadInt();
            expressions.clear();
            for(int j = 0; j < len; ++j)
            {
                Expression tmp = new Expression();
                tmp.Read(buf);
                expressions.addElement(tmp);
            }
        }
        Select(0);
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "expressions = {\n";
        for(int i = 0; i < expressions.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)expressions.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < expressions.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        return str;
    }

    // Attributegroup convenience methods
    public void AddExpressions(Expression obj)
    {
        expressions.addElement(new Expression(obj));
        Select(0);
    }

    public void ClearExpressions()
    {
        expressions.clear();
        Select(0);
    }

    public void RemoveExpressions(int index)
    {
        if(index >= 0 && index < expressions.size())
        {
            expressions.remove(index);
            Select(0);
        }
    }

    public int GetNumExpressions()
    {
        return expressions.size();
    }

    public Expression GetExpressions(int i)
    {
        Expression tmp = (Expression)expressions.elementAt(i);
        return tmp;
    }


    // Attributes
    private Vector expressions; // vector of Expression objects
}

