// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;


// ****************************************************************************
// Class: DatabaseAttributes
//
// Purpose:
//    This class contains the database attributes.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class DatabaseAttributes extends AttributeSubject
{
    private static int DatabaseAttributes_numAdditionalAtts = 1;

    public DatabaseAttributes()
    {
        super(DatabaseAttributes_numAdditionalAtts);

        state = 0;
    }

    public DatabaseAttributes(int nMoreFields)
    {
        super(DatabaseAttributes_numAdditionalAtts + nMoreFields);

        state = 0;
    }

    public DatabaseAttributes(DatabaseAttributes obj)
    {
        super(obj);

        state = obj.state;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return DatabaseAttributes_numAdditionalAtts;
    }

    public boolean equals(DatabaseAttributes obj)
    {
        // Create the return value
        return ((state == obj.state));
    }

    // Property setting methods
    public void SetState(int state_)
    {
        state = state_;
        Select(0);
    }

    // Property getting methods
    public int GetState() { return state; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(state);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        SetState(buf.ReadInt());
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intToString("state", state, indent) + "\n";
        return str;
    }


    // Attributes
    private int state;
}

