// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;

import java.util.Vector;
import java.lang.Double;

// ****************************************************************************
// Class: AxisRestrictionAttributes
//
// Purpose:
//    Attributes for axis restrictions
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class AxisRestrictionAttributes extends AttributeSubject
{
    private static int AxisRestrictionAttributes_numAdditionalAtts = 3;

    public AxisRestrictionAttributes()
    {
        super(AxisRestrictionAttributes_numAdditionalAtts);

        names = new Vector();
        minima = new Vector();
        maxima = new Vector();
    }

    public AxisRestrictionAttributes(int nMoreFields)
    {
        super(AxisRestrictionAttributes_numAdditionalAtts + nMoreFields);

        names = new Vector();
        minima = new Vector();
        maxima = new Vector();
    }

    public AxisRestrictionAttributes(AxisRestrictionAttributes obj)
    {
        super(obj);

        int i;

        names = new Vector(obj.names.size());
        for(i = 0; i < obj.names.size(); ++i)
            names.addElement(new String((String)obj.names.elementAt(i)));

        minima = new Vector(obj.minima.size());
        for(i = 0; i < obj.minima.size(); ++i)
        {
            Double dv = (Double)obj.minima.elementAt(i);
            minima.addElement(new Double(dv.doubleValue()));
        }

        maxima = new Vector(obj.maxima.size());
        for(i = 0; i < obj.maxima.size(); ++i)
        {
            Double dv = (Double)obj.maxima.elementAt(i);
            maxima.addElement(new Double(dv.doubleValue()));
        }


        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return AxisRestrictionAttributes_numAdditionalAtts;
    }

    public boolean equals(AxisRestrictionAttributes obj)
    {
        int i;

        // Compare the elements in the names vector.
        boolean names_equal = (obj.names.size() == names.size());
        for(i = 0; (i < names.size()) && names_equal; ++i)
        {
            // Make references to String from Object.
            String names1 = (String)names.elementAt(i);
            String names2 = (String)obj.names.elementAt(i);
            names_equal = names1.equals(names2);
        }
        // Compare the elements in the minima vector.
        boolean minima_equal = (obj.minima.size() == minima.size());
        for(i = 0; (i < minima.size()) && minima_equal; ++i)
        {
            // Make references to Double from Object.
            Double minima1 = (Double)minima.elementAt(i);
            Double minima2 = (Double)obj.minima.elementAt(i);
            minima_equal = minima1.equals(minima2);
        }
        // Compare the elements in the maxima vector.
        boolean maxima_equal = (obj.maxima.size() == maxima.size());
        for(i = 0; (i < maxima.size()) && maxima_equal; ++i)
        {
            // Make references to Double from Object.
            Double maxima1 = (Double)maxima.elementAt(i);
            Double maxima2 = (Double)obj.maxima.elementAt(i);
            maxima_equal = maxima1.equals(maxima2);
        }
        // Create the return value
        return (names_equal &&
                minima_equal &&
                maxima_equal);
    }

    // Property setting methods
    public void SetNames(Vector names_)
    {
        names = names_;
        Select(0);
    }

    public void SetMinima(Vector minima_)
    {
        minima = minima_;
        Select(1);
    }

    public void SetMaxima(Vector maxima_)
    {
        maxima = maxima_;
        Select(2);
    }

    // Property getting methods
    public Vector GetNames() { return names; }
    public Vector GetMinima() { return minima; }
    public Vector GetMaxima() { return maxima; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteStringVector(names);
        if(WriteSelect(1, buf))
            buf.WriteDoubleVector(minima);
        if(WriteSelect(2, buf))
            buf.WriteDoubleVector(maxima);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetNames(buf.ReadStringVector());
            break;
        case 1:
            SetMinima(buf.ReadDoubleVector());
            break;
        case 2:
            SetMaxima(buf.ReadDoubleVector());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + stringVectorToString("names", names, indent) + "\n";
        str = str + doubleVectorToString("minima", minima, indent) + "\n";
        str = str + doubleVectorToString("maxima", maxima, indent) + "\n";
        return str;
    }


    // Attributes
    private Vector names; // vector of String objects
    private Vector minima; // vector of Double objects
    private Vector maxima; // vector of Double objects
}

