// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;


// ****************************************************************************
// Class: AxisAttributes
//
// Purpose:
//    Contains the properties for one axis.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class AxisAttributes extends AttributeSubject
{
    private static int AxisAttributes_numAdditionalAtts = 4;

    public AxisAttributes()
    {
        super(AxisAttributes_numAdditionalAtts);

        title = new AxisTitles();
        label = new AxisLabels();
        tickMarks = new AxisTickMarks();
        grid = false;
    }

    public AxisAttributes(int nMoreFields)
    {
        super(AxisAttributes_numAdditionalAtts + nMoreFields);

        title = new AxisTitles();
        label = new AxisLabels();
        tickMarks = new AxisTickMarks();
        grid = false;
    }

    public AxisAttributes(AxisAttributes obj)
    {
        super(obj);

        title = new AxisTitles(obj.title);
        label = new AxisLabels(obj.label);
        tickMarks = new AxisTickMarks(obj.tickMarks);
        grid = obj.grid;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return AxisAttributes_numAdditionalAtts;
    }

    public boolean equals(AxisAttributes obj)
    {
        // Create the return value
        return ((title.equals(obj.title)) &&
                (label.equals(obj.label)) &&
                (tickMarks.equals(obj.tickMarks)) &&
                (grid == obj.grid));
    }

    // Property setting methods
    public void SetTitle(AxisTitles title_)
    {
        title = title_;
        Select(0);
    }

    public void SetLabel(AxisLabels label_)
    {
        label = label_;
        Select(1);
    }

    public void SetTickMarks(AxisTickMarks tickMarks_)
    {
        tickMarks = tickMarks_;
        Select(2);
    }

    public void SetGrid(boolean grid_)
    {
        grid = grid_;
        Select(3);
    }

    // Property getting methods
    public AxisTitles    GetTitle() { return title; }
    public AxisLabels    GetLabel() { return label; }
    public AxisTickMarks GetTickMarks() { return tickMarks; }
    public boolean       GetGrid() { return grid; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            title.Write(buf);
        if(WriteSelect(1, buf))
            label.Write(buf);
        if(WriteSelect(2, buf))
            tickMarks.Write(buf);
        if(WriteSelect(3, buf))
            buf.WriteBool(grid);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            title.Read(buf);
            Select(0);
            break;
        case 1:
            label.Read(buf);
            Select(1);
            break;
        case 2:
            tickMarks.Read(buf);
            Select(2);
            break;
        case 3:
            SetGrid(buf.ReadBool());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "title = {\n" + title.toString(indent + "    ") + indent + "}\n";
        str = str + indent + "label = {\n" + label.toString(indent + "    ") + indent + "}\n";
        str = str + indent + "tickMarks = {\n" + tickMarks.toString(indent + "    ") + indent + "}\n";
        str = str + boolToString("grid", grid, indent) + "\n";
        return str;
    }


    // Attributes
    private AxisTitles    title;
    private AxisLabels    label;
    private AxisTickMarks tickMarks;
    private boolean       grid;
}

