// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit;


// ****************************************************************************
// Class: Axes3D
//
// Purpose:
//    Contains the properties for the 3D axes.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class Axes3D extends AttributeSubject
{
    private static int Axes3D_numAdditionalAtts = 19;

    // Enum values
    public final static int AXES_CLOSESTTRIAD = 0;
    public final static int AXES_FURTHESTTRIAD = 1;
    public final static int AXES_OUTSIDEEDGES = 2;
    public final static int AXES_STATICTRIAD = 3;
    public final static int AXES_STATICEDGES = 4;

    public final static int LOCATION_INSIDE = 0;
    public final static int LOCATION_OUTSIDE = 1;
    public final static int LOCATION_BOTH = 2;


    public Axes3D()
    {
        super(Axes3D_numAdditionalAtts);

        visible = true;
        autoSetTicks = true;
        autoSetScaling = true;
        lineWidth = 0;
        tickLocation = LOCATION_INSIDE;
        axesType = AXES_CLOSESTTRIAD;
        triadFlag = true;
        bboxFlag = true;
        xAxis = new AxisAttributes();
        yAxis = new AxisAttributes();
        zAxis = new AxisAttributes();
        setBBoxLocation = false;
        bboxLocation = new double[6];
        bboxLocation[0] = 0;
        bboxLocation[1] = 1;
        bboxLocation[2] = 0;
        bboxLocation[3] = 1;
        bboxLocation[4] = 0;
        bboxLocation[5] = 1;
        triadColor = new int[3];
        triadColor[0] = 0;
        triadColor[1] = 0;
        triadColor[2] = 0;
        triadLineWidth = 1f;
        triadFont = 0;
        triadBold = true;
        triadItalic = true;
        triadSetManually = false;
    }

    public Axes3D(int nMoreFields)
    {
        super(Axes3D_numAdditionalAtts + nMoreFields);

        visible = true;
        autoSetTicks = true;
        autoSetScaling = true;
        lineWidth = 0;
        tickLocation = LOCATION_INSIDE;
        axesType = AXES_CLOSESTTRIAD;
        triadFlag = true;
        bboxFlag = true;
        xAxis = new AxisAttributes();
        yAxis = new AxisAttributes();
        zAxis = new AxisAttributes();
        setBBoxLocation = false;
        bboxLocation = new double[6];
        bboxLocation[0] = 0;
        bboxLocation[1] = 1;
        bboxLocation[2] = 0;
        bboxLocation[3] = 1;
        bboxLocation[4] = 0;
        bboxLocation[5] = 1;
        triadColor = new int[3];
        triadColor[0] = 0;
        triadColor[1] = 0;
        triadColor[2] = 0;
        triadLineWidth = 1f;
        triadFont = 0;
        triadBold = true;
        triadItalic = true;
        triadSetManually = false;
    }

    public Axes3D(Axes3D obj)
    {
        super(obj);

        int i;

        visible = obj.visible;
        autoSetTicks = obj.autoSetTicks;
        autoSetScaling = obj.autoSetScaling;
        lineWidth = obj.lineWidth;
        tickLocation = obj.tickLocation;
        axesType = obj.axesType;
        triadFlag = obj.triadFlag;
        bboxFlag = obj.bboxFlag;
        xAxis = new AxisAttributes(obj.xAxis);
        yAxis = new AxisAttributes(obj.yAxis);
        zAxis = new AxisAttributes(obj.zAxis);
        setBBoxLocation = obj.setBBoxLocation;
        bboxLocation = new double[6];
        for(i = 0; i < obj.bboxLocation.length; ++i)
            bboxLocation[i] = obj.bboxLocation[i];

        triadColor = new int[3];
        triadColor[0] = obj.triadColor[0];
        triadColor[1] = obj.triadColor[1];
        triadColor[2] = obj.triadColor[2];

        triadLineWidth = obj.triadLineWidth;
        triadFont = obj.triadFont;
        triadBold = obj.triadBold;
        triadItalic = obj.triadItalic;
        triadSetManually = obj.triadSetManually;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return Axes3D_numAdditionalAtts;
    }

    public boolean equals(Axes3D obj)
    {
        int i;

        // Compare the bboxLocation arrays.
        boolean bboxLocation_equal = true;
        for(i = 0; i < 6 && bboxLocation_equal; ++i)
            bboxLocation_equal = (bboxLocation[i] == obj.bboxLocation[i]);

        // Compare the triadColor arrays.
        boolean triadColor_equal = true;
        for(i = 0; i < 3 && triadColor_equal; ++i)
            triadColor_equal = (triadColor[i] == obj.triadColor[i]);

        // Create the return value
        return ((visible == obj.visible) &&
                (autoSetTicks == obj.autoSetTicks) &&
                (autoSetScaling == obj.autoSetScaling) &&
                (lineWidth == obj.lineWidth) &&
                (tickLocation == obj.tickLocation) &&
                (axesType == obj.axesType) &&
                (triadFlag == obj.triadFlag) &&
                (bboxFlag == obj.bboxFlag) &&
                (xAxis.equals(obj.xAxis)) &&
                (yAxis.equals(obj.yAxis)) &&
                (zAxis.equals(obj.zAxis)) &&
                (setBBoxLocation == obj.setBBoxLocation) &&
                bboxLocation_equal &&
                triadColor_equal &&
                (triadLineWidth == obj.triadLineWidth) &&
                (triadFont == obj.triadFont) &&
                (triadBold == obj.triadBold) &&
                (triadItalic == obj.triadItalic) &&
                (triadSetManually == obj.triadSetManually));
    }

    // Property setting methods
    public void SetVisible(boolean visible_)
    {
        visible = visible_;
        Select(0);
    }

    public void SetAutoSetTicks(boolean autoSetTicks_)
    {
        autoSetTicks = autoSetTicks_;
        Select(1);
    }

    public void SetAutoSetScaling(boolean autoSetScaling_)
    {
        autoSetScaling = autoSetScaling_;
        Select(2);
    }

    public void SetLineWidth(int lineWidth_)
    {
        lineWidth = lineWidth_;
        Select(3);
    }

    public void SetTickLocation(int tickLocation_)
    {
        tickLocation = tickLocation_;
        Select(4);
    }

    public void SetAxesType(int axesType_)
    {
        axesType = axesType_;
        Select(5);
    }

    public void SetTriadFlag(boolean triadFlag_)
    {
        triadFlag = triadFlag_;
        Select(6);
    }

    public void SetBboxFlag(boolean bboxFlag_)
    {
        bboxFlag = bboxFlag_;
        Select(7);
    }

    public void SetXAxis(AxisAttributes xAxis_)
    {
        xAxis = xAxis_;
        Select(8);
    }

    public void SetYAxis(AxisAttributes yAxis_)
    {
        yAxis = yAxis_;
        Select(9);
    }

    public void SetZAxis(AxisAttributes zAxis_)
    {
        zAxis = zAxis_;
        Select(10);
    }

    public void SetSetBBoxLocation(boolean setBBoxLocation_)
    {
        setBBoxLocation = setBBoxLocation_;
        Select(11);
    }

    public void SetBboxLocation(double[] bboxLocation_)
    {
        for(int i = 0; i < 6; ++i)
             bboxLocation[i] = bboxLocation_[i];
        Select(12);
    }

    public void SetTriadColor(int[] triadColor_)
    {
        triadColor[0] = triadColor_[0];
        triadColor[1] = triadColor_[1];
        triadColor[2] = triadColor_[2];
        Select(13);
    }

    public void SetTriadColor(int e0, int e1, int e2)
    {
        triadColor[0] = e0;
        triadColor[1] = e1;
        triadColor[2] = e2;
        Select(13);
    }

    public void SetTriadLineWidth(float triadLineWidth_)
    {
        triadLineWidth = triadLineWidth_;
        Select(14);
    }

    public void SetTriadFont(int triadFont_)
    {
        triadFont = triadFont_;
        Select(15);
    }

    public void SetTriadBold(boolean triadBold_)
    {
        triadBold = triadBold_;
        Select(16);
    }

    public void SetTriadItalic(boolean triadItalic_)
    {
        triadItalic = triadItalic_;
        Select(17);
    }

    public void SetTriadSetManually(boolean triadSetManually_)
    {
        triadSetManually = triadSetManually_;
        Select(18);
    }

    // Property getting methods
    public boolean        GetVisible() { return visible; }
    public boolean        GetAutoSetTicks() { return autoSetTicks; }
    public boolean        GetAutoSetScaling() { return autoSetScaling; }
    public int            GetLineWidth() { return lineWidth; }
    public int            GetTickLocation() { return tickLocation; }
    public int            GetAxesType() { return axesType; }
    public boolean        GetTriadFlag() { return triadFlag; }
    public boolean        GetBboxFlag() { return bboxFlag; }
    public AxisAttributes GetXAxis() { return xAxis; }
    public AxisAttributes GetYAxis() { return yAxis; }
    public AxisAttributes GetZAxis() { return zAxis; }
    public boolean        GetSetBBoxLocation() { return setBBoxLocation; }
    public double[]       GetBboxLocation() { return bboxLocation; }
    public int[]          GetTriadColor() { return triadColor; }
    public float          GetTriadLineWidth() { return triadLineWidth; }
    public int            GetTriadFont() { return triadFont; }
    public boolean        GetTriadBold() { return triadBold; }
    public boolean        GetTriadItalic() { return triadItalic; }
    public boolean        GetTriadSetManually() { return triadSetManually; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteBool(visible);
        if(WriteSelect(1, buf))
            buf.WriteBool(autoSetTicks);
        if(WriteSelect(2, buf))
            buf.WriteBool(autoSetScaling);
        if(WriteSelect(3, buf))
            buf.WriteInt(lineWidth);
        if(WriteSelect(4, buf))
            buf.WriteInt(tickLocation);
        if(WriteSelect(5, buf))
            buf.WriteInt(axesType);
        if(WriteSelect(6, buf))
            buf.WriteBool(triadFlag);
        if(WriteSelect(7, buf))
            buf.WriteBool(bboxFlag);
        if(WriteSelect(8, buf))
            xAxis.Write(buf);
        if(WriteSelect(9, buf))
            yAxis.Write(buf);
        if(WriteSelect(10, buf))
            zAxis.Write(buf);
        if(WriteSelect(11, buf))
            buf.WriteBool(setBBoxLocation);
        if(WriteSelect(12, buf))
            buf.WriteDoubleArray(bboxLocation);
        if(WriteSelect(13, buf))
            buf.WriteIntArray(triadColor);
        if(WriteSelect(14, buf))
            buf.WriteFloat(triadLineWidth);
        if(WriteSelect(15, buf))
            buf.WriteInt(triadFont);
        if(WriteSelect(16, buf))
            buf.WriteBool(triadBold);
        if(WriteSelect(17, buf))
            buf.WriteBool(triadItalic);
        if(WriteSelect(18, buf))
            buf.WriteBool(triadSetManually);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetVisible(buf.ReadBool());
            break;
        case 1:
            SetAutoSetTicks(buf.ReadBool());
            break;
        case 2:
            SetAutoSetScaling(buf.ReadBool());
            break;
        case 3:
            SetLineWidth(buf.ReadInt());
            break;
        case 4:
            SetTickLocation(buf.ReadInt());
            break;
        case 5:
            SetAxesType(buf.ReadInt());
            break;
        case 6:
            SetTriadFlag(buf.ReadBool());
            break;
        case 7:
            SetBboxFlag(buf.ReadBool());
            break;
        case 8:
            xAxis.Read(buf);
            Select(8);
            break;
        case 9:
            yAxis.Read(buf);
            Select(9);
            break;
        case 10:
            zAxis.Read(buf);
            Select(10);
            break;
        case 11:
            SetSetBBoxLocation(buf.ReadBool());
            break;
        case 12:
            SetBboxLocation(buf.ReadDoubleArray());
            break;
        case 13:
            SetTriadColor(buf.ReadIntArray());
            break;
        case 14:
            SetTriadLineWidth(buf.ReadFloat());
            break;
        case 15:
            SetTriadFont(buf.ReadInt());
            break;
        case 16:
            SetTriadBold(buf.ReadBool());
            break;
        case 17:
            SetTriadItalic(buf.ReadBool());
            break;
        case 18:
            SetTriadSetManually(buf.ReadBool());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + boolToString("visible", visible, indent) + "\n";
        str = str + boolToString("autoSetTicks", autoSetTicks, indent) + "\n";
        str = str + boolToString("autoSetScaling", autoSetScaling, indent) + "\n";
        str = str + intToString("lineWidth", lineWidth, indent) + "\n";
        str = str + indent + "tickLocation = ";
        if(tickLocation == LOCATION_INSIDE)
            str = str + "LOCATION_INSIDE";
        if(tickLocation == LOCATION_OUTSIDE)
            str = str + "LOCATION_OUTSIDE";
        if(tickLocation == LOCATION_BOTH)
            str = str + "LOCATION_BOTH";
        str = str + "\n";
        str = str + indent + "axesType = ";
        if(axesType == AXES_CLOSESTTRIAD)
            str = str + "AXES_CLOSESTTRIAD";
        if(axesType == AXES_FURTHESTTRIAD)
            str = str + "AXES_FURTHESTTRIAD";
        if(axesType == AXES_OUTSIDEEDGES)
            str = str + "AXES_OUTSIDEEDGES";
        if(axesType == AXES_STATICTRIAD)
            str = str + "AXES_STATICTRIAD";
        if(axesType == AXES_STATICEDGES)
            str = str + "AXES_STATICEDGES";
        str = str + "\n";
        str = str + boolToString("triadFlag", triadFlag, indent) + "\n";
        str = str + boolToString("bboxFlag", bboxFlag, indent) + "\n";
        str = str + indent + "xAxis = {\n" + xAxis.toString(indent + "    ") + indent + "}\n";
        str = str + indent + "yAxis = {\n" + yAxis.toString(indent + "    ") + indent + "}\n";
        str = str + indent + "zAxis = {\n" + zAxis.toString(indent + "    ") + indent + "}\n";
        str = str + boolToString("setBBoxLocation", setBBoxLocation, indent) + "\n";
        str = str + doubleArrayToString("bboxLocation", bboxLocation, indent) + "\n";
        str = str + intArrayToString("triadColor", triadColor, indent) + "\n";
        str = str + floatToString("triadLineWidth", triadLineWidth, indent) + "\n";
        str = str + intToString("triadFont", triadFont, indent) + "\n";
        str = str + boolToString("triadBold", triadBold, indent) + "\n";
        str = str + boolToString("triadItalic", triadItalic, indent) + "\n";
        str = str + boolToString("triadSetManually", triadSetManually, indent) + "\n";
        return str;
    }


    // Attributes
    private boolean        visible;
    private boolean        autoSetTicks;
    private boolean        autoSetScaling;
    private int            lineWidth;
    private int            tickLocation;
    private int            axesType;
    private boolean        triadFlag;
    private boolean        bboxFlag;
    private AxisAttributes xAxis;
    private AxisAttributes yAxis;
    private AxisAttributes zAxis;
    private boolean        setBBoxLocation;
    private double[]       bboxLocation;
    private int[]          triadColor;
    private float          triadLineWidth;
    private int            triadFont;
    private boolean        triadBold;
    private boolean        triadItalic;
    private boolean        triadSetManually;
}

