// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <QvisPredefinedViewports.h>
#include <QPixmap>
#include <QMenu>

/* XPM */
static const char * vicon_00_xpm[] = {
"60 40 2 1",
".    c #000000",
"+    c #DDDDDD",
"............................................................",
"............................................................",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"............................................................",
"............................................................"};

/* XPM */
static const char * vicon_01_xpm[] = {
"60 40 2 1",
".    c #000000",
"+    c #DDDDDD",
"............................................................",
"............................................................",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"............................................................",
"............................................................"};

/* XPM */
static const char * vicon_02_xpm[] = {
"60 40 2 1",
".    c #000000",
"+    c #DDDDDD",
"............................................................",
"............................................................",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"............................................................",
"............................................................",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"..+++++++++++++++++++++++++++..+++++++++++++++++++++++++++..",
"............................................................",
"............................................................"};

/* XPM */
static const char * vicon_03_xpm[] = {
"60 40 2 1",
".    c #000000",
"+    c #DDDDDD",
"............................................................",
"............................................................",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"............................................................",
"............................................................"};

/* XPM */
static const char * vicon_04_xpm[] = {
"60 40 2 1",
".    c #000000",
"+    c #DDDDDD",
"............................................................",
"............................................................",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..++++++++++++++..++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++..................++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++++++++++++++++++++++++++++++..",
"............................................................",
"............................................................"};

/* XPM */
static const char * vicon_05_xpm[] = {
"60 40 2 1",
".    c #000000",
"+    c #DDDDDD",
"............................................................",
"............................................................",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++..................++++..++++..................++++..",
"..++++++..................++++..++++..................++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..++++++++++++++..++++..++++..++++++++++++++..++++..",
"..++++++..................++++..++++..................++++..",
"..++++++..................++++..++++..................++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"..++++++++++++++++++++++++++++..++++++++++++++++++++++++++..",
"............................................................",
"............................................................"};


// ****************************************************************************
// Method: QvisPredefinedViewports::QvisPredefinedViewports
//
// Purpose: 
//   Constructor.
//
// Programmer: Brad Whitlock
// Creation:   Mon Oct 2 18:09:33 PST 2006
//
// Modifications:
//   Brad Whitlock, Tue Apr  8 15:26:49 PDT 2008
//   Support for internationalization.
//
//   Brad Whitlock, Tue Oct  7 10:28:20 PDT 2008
//   Qt 4.
//
// ****************************************************************************

QvisPredefinedViewports::QvisPredefinedViewports(QWidget *parent) : QPushButton(parent)
{
    setText("Layouts");

    // Insert items.
    menu = new QMenu(0);
    menu->addAction(QIcon(QPixmap(vicon_00_xpm)), tr("Single"));
    menu->addAction(QIcon(QPixmap(vicon_01_xpm)), tr("Side by side"));
    menu->addAction(QIcon(QPixmap(vicon_02_xpm)), tr("Two by Two"));
    menu->addAction(QIcon(QPixmap(vicon_03_xpm)), tr("Picture in picture 1"));
    menu->addAction(QIcon(QPixmap(vicon_04_xpm)), tr("Picture in picture 2"));
    menu->addAction(QIcon(QPixmap(vicon_05_xpm)), tr("2x Picture in picture"));
    setMenu(menu);
    connect(menu, SIGNAL(triggered(QAction*)),
            this, SLOT(emitActivated(QAction*)));
}

// ****************************************************************************
// Method: QvisPredefinedViewports::~QvisPredefinedViewports
//
// Purpose: 
//   Destructor.
//
// Programmer: Brad Whitlock
// Creation:   Mon Oct 2 18:09:49 PST 2006
//
// Modifications:
//   
// ****************************************************************************

QvisPredefinedViewports::~QvisPredefinedViewports()
{
    delete menu;
}

// ****************************************************************************
// Method: QvisPredefinedViewports::emitActivated
//
// Purpose: 
//   Emits the activated signal with the index of the activated action.
//
// Arguments:
//   a : The action that was triggered.
//
// Programmer: Brad Whitlock
// Creation:   Tue Oct  7 10:26:10 PDT 2008
//
// Modifications:
//   
// ****************************************************************************

void
QvisPredefinedViewports::emitActivated(QAction *a)
{
    emit activated(menu->actions().indexOf(a));
}
