// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: volimagePluginInfo.C
// ****************************************************************************

#include <volimagePluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(volimage,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(volimage,General)

// ****************************************************************************
//  Method: volimageGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
volimageGeneralPluginInfo::GetName() const
{
    return "volimage";
}

// ****************************************************************************
//  Method: volimageGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
volimageGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: volimageGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
volimageGeneralPluginInfo::GetID() const
{
    return "volimage_1.0";
}
// ****************************************************************************
//  Method: volimageGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
volimageGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: volimageGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
volimageGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  volimageGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a volimage database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
volimageGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*3D.ux");
    defaultPatterns.push_back("*3D.uy");
    defaultPatterns.push_back("*3D.uz");
    defaultPatterns.push_back("*3D.rho");
    defaultPatterns.push_back("*3D.p");
    defaultPatterns.push_back("*3D.s");
    defaultPatterns.push_back("*3D.div");
    defaultPatterns.push_back("*3D.curl");
    defaultPatterns.push_back("*3D.mag");
    defaultPatterns.push_back("*3D.veldiv");
    defaultPatterns.push_back("*3D.velcurl");
    defaultPatterns.push_back("*3D.velmag");
    defaultPatterns.push_back("*3D.z");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  volimageGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a volimage database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
volimageGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  volimageGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the volimage plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
volimageGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
