// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtvolimageFileFormat.h                        //
// ************************************************************************* //

#ifndef AVT_volimage_FILE_FORMAT_H
#define AVT_volimage_FILE_FORMAT_H

#include <avtSTMDFileFormat.h>

#include <vector>
#include <string>

// ****************************************************************************
//  Class: avtvolimageFileFormat
//
//  Purpose:
//      Reads in volimage files as a plugin to VisIt.
//
//  Programmer: sjogreen2 -- generated by xml2avt
//  Creation:   Mon Jun 20 08:59:36 PDT 2011
//
// ****************************************************************************

class avtvolimageFileFormat : public avtSTMDFileFormat
{
  public:
                       avtvolimageFileFormat(const char *);
    virtual           ~avtvolimageFileFormat() {;};

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, int domain,
    //                                     const char *type, void *args, 
    //                                     DestructorFunction &);
    //

    //
    // If you know the cycle number, overload this function.
    // Otherwise, VisIt will make up a reasonable one for you.
    //
    // virtual int         GetCycle(void);
    //

    virtual const char    *GetType(void)   { return "volimage"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

  protected:
    // DATA MEMBERS

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);

// imagevolume data
    void Initialize();
    bool m_initialized;
    bool m_data_stored;
    bool m_CartGrid;
    bool m_grid_stored;
    double m_time;
    std::vector<float*> m_dataptr;
    std::vector<float*> m_gridptr;
    std::string m_filename;
    std::string m_gridname;
    std::string m_gridfilename;
    int m_prec;
    int m_nblocks;
    std::vector<double> m_gridsize;
    std::string m_mode;
    std::vector<double> m_xmin;
    std::vector<double> m_ymin;
    std::vector<double> m_zmin;
    std::vector<int> m_ni;
    std::vector<int> m_nj;
    std::vector<int> m_nk;
    std::vector<off_t> m_offset;
    std::vector<off_t> m_gridoffset;
};


#endif
