#include <ffpPluginInfo.h>
#include <avtffpFileFormat.h>
#include <avtSTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  ffpCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a ffp database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
ffpCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STSD;
}

// ****************************************************************************
//  Method: ffpCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a ffp database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A ffp database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
ffpCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    int nTimestep = nList / nBlock;
    avtSTSDFileFormat ***ffl = new avtSTSDFileFormat**[nTimestep];
    for (int i = 0; i < nTimestep; i++)
    {
        ffl[i] = new avtSTSDFileFormat*[nBlock];
        for (int j = 0; j < nBlock; j++)
        {
            ffl[i][j] = new avtffpFileFormat(list[i*nBlock + j]);
        }
    }
    avtSTSDFileFormatInterface *inter
           = new avtSTSDFileFormatInterface(ffl, nTimestep, nBlock);
    return new avtGenericDatabase(inter);
}
