#ifndef AVT_ffp_FILE_FORMAT_H
#define AVT_ffp_FILE_FORMAT_H

#include <avtSTSDFileFormat.h>
#include <string>
#include <vector>
#include <set>
#include <zlib.h>

class RealStuff {
 public:
    int number;
    double valeur;
    double x,y,z ;
    struct compare_RealStuff
    {
        bool operator () (const RealStuff& n1, const RealStuff& n2) const
        {
            return (n1.valeur < n2.valeur);
        };
    };
};
class UnvElement { // Element class
 public:
    int number;
    int label;
    int typelt ;
    mutable int matid ; // mutable
    int* nodes ;
    struct compare_UnvElement
    {
        bool operator () (const UnvElement& e1, const UnvElement& e2) const
        {
            return (e1.label < e2.label);
        };
    };
};


// ****************************************************************************
//  Class: avtffpFileFormat
//
//  Purpose:
//      Reads in ffp files as a plugin to VisIt.
//
//  Programmer: cessenat -- generated by xml2avt
//  Creation:   Sat Apr 28 11:57:59 PDT 2018
//
// ****************************************************************************

class avtffpFileFormat : public avtSTSDFileFormat
{
  public:
                       avtffpFileFormat(const char *filename);
    virtual           ~avtffpFileFormat(); // Validate the destructor as in Curve2D

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    virtual void      *GetAuxiliaryData(const char *var, const char *type,
                                      void *args, DestructorFunction &);
    //

    //
    // These are used to declare what the current time and cycle are for the
    // file.  These should only be defined if the file format knows what the
    // time and/or cycle is.
    //
    virtual bool      ReturnsValidCycle() const { return true; };
    virtual int          GetCycle(void);
    virtual bool      ReturnsValidTime() const { return true; };
    virtual double       GetTime(void);
    int                   GetCycleFromFilename(const char *f) const;
    //

    virtual const char    *GetType(void)   { return "Far Field Pattern or Radiation Diagram"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(const char *);
    virtual vtkDataArray  *GetVar(const char *);
    virtual vtkDataArray  *GetVectorVar(const char *);

  protected:
    // DATA MEMBERS

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);
    virtual void           ReadFile(void);
    FILE* handle;          // File handle for ffp/rcs file
    gzFile gzhandle ;      // File handle for ffp.gz file
    int nbtheta ;          // Number of theta angles
    int nbphi ;            // Same for phi
    int phicomplete ;      // Indicates if phi is all around
    int thetacomplete ;    // Indicates if theta goes to both poles
    std::string filename;  // Mesh file name, including .unv or .unv.gz extension
    bool fileRead;         // Says if file has already been read or not
    int debuglevel ; 
    double range[6] ;      // geometrical mesh range
    double * valeurs ;     // FFP values
    double * maleurs ;
    double * thetas ;      // Stored theta angles
    double * phis ;        // Stored phi angles
    double fac ;           // Sizing factor for mesh setting
    double phi0 ;          // phi start value
    int imod ;             // 0: regular complete theta phi, 1: triangulation is provided (later on or in file .unv)
    int np, nt ;           // Indicates the number of points and of triangles (or quads or whatever)
    std::set<UnvElement, UnvElement::compare_UnvElement> meshUnvElements;  // Full mesh all types of elements
    double                 ffpTime;
    int                    ffpCycle;
};


#endif
