// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                          avtZipWrapperOptions.C                           //
// ************************************************************************* //

#include <avtZipWrapperOptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>

using std::string;
using std::vector;


// ****************************************************************************
//  Function: GetZipWrapperReadOptions
//
//  Purpose:
//      Creates the options for ZipWrapper readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: miller -- generated by xml2avt
//  Creation:   April 29, 2008 
//
// ****************************************************************************

DBOptionsAttributes *
GetZipWrapperReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    rv->SetString("TMPDIR for decompressed files", "$TMPDIR");
    rv->SetString("Unique moniker for dirs made in $TMPDIR", "$USER");
    rv->SetInt("Max. # decompressed files", 50);
    rv->SetString("Decompression command", "");
    rv->SetBool("Don't atexit()", false);
    return rv;
}


// ****************************************************************************
//  Function: GetZipWrapperWriteOptions
//
//  Purpose:
//      Creates the options for ZipWrapper writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: miller -- generated by xml2avt
//  Creation:   April 29, 2008 
//
// ****************************************************************************

DBOptionsAttributes *
GetZipWrapperWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
