// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ZipWrapperPluginInfo.C
// ****************************************************************************

#include <ZipWrapperPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(ZipWrapper,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(ZipWrapper,General)

// ****************************************************************************
//  Method: ZipWrapperGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ZipWrapperGeneralPluginInfo::GetName() const
{
    return "ZipWrapper";
}

// ****************************************************************************
//  Method: ZipWrapperGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ZipWrapperGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ZipWrapperGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ZipWrapperGeneralPluginInfo::GetID() const
{
    return "ZipWrapper_1.0";
}
// ****************************************************************************
//  Method: ZipWrapperGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ZipWrapperGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: ZipWrapperGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ZipWrapperGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  ZipWrapperGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a ZipWrapper database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
ZipWrapperGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.gz");
    defaultPatterns.push_back("*.bz2");
    defaultPatterns.push_back("*.zip");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  ZipWrapperGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a ZipWrapper database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ZipWrapperGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  ZipWrapperGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the ZipWrapper plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ZipWrapperGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
