// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtXSFFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_XSF_FILE_FORMAT_H
#define AVT_XSF_FILE_FORMAT_H

#include <avtMTSDFileFormat.h>

#include <vector>
#include <string>


// ****************************************************************************
//  Class: avtXSFFileFormat
//
//  Purpose:
//      Reads in XSF files as a plugin to VisIt.
//
//  Programmer: js9 -- generated by xml2avt
//  Creation:   Wed Sep 28 10:30:07 PDT 2011
//
// ****************************************************************************

class avtXSFFileFormat : public avtMTSDFileFormat
{
  public:
                       avtXSFFileFormat(const char *);
    virtual           ~avtXSFFileFormat();

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, int timestep, 
    //                                     const char *type, void *args, 
    //                                     DestructorFunction &);
    //

    //
    // If you know the times and cycle numbers, overload this function.
    // Otherwise, VisIt will make up some reasonable ones for you.
    //
    // virtual void        GetCycles(std::vector<int> &);
    // virtual void        GetTimes(std::vector<double> &);
    //

    virtual int            GetNTimesteps(void);

    virtual const char    *GetType(void)   { return "XSF"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

  protected:
    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);

    void OpenFileAtBeginning();
    void ReadAllMetaData();
    void ReadAtomsForTimestep(int);


  protected:
    struct Atom
    {
        int   e;
        float x;
        float y;
        float z; 
        float fx;
        float fy;
        float fz;
    };

    struct UCV
    {
        double v[3][3];
        double *operator[](int i) { return v[i]; }
    };

    struct Mesh
    {
        char  name[1024];
        int   dim;
        int   numnodes[3];
        float origin[3];
        UCV   ucv;
        std::vector<std::string>       var_names;
        std::vector<istream::pos_type> var_filepos;
        void clear()
        {
            dim         = -1;
            name[0]     = '\0';
            numnodes[0] = 0;
            numnodes[1] = 0;
            numnodes[2] = 0;
        }
    };

    ifstream         in;
    std::string      filename;
    bool             metadata_read;

    int              ntimesteps;
    int              natoms;
    bool             hasforces;

    std::vector<Atom> currentAtoms;

    std::vector<Mesh> allMeshes; // one per BLOCK_DATAGRID (i.e. a "mesh"

    std::vector<UCV> unitCell; // one, or one per timestep (or maybe none??)

    std::vector<istream::pos_type> atom_filepos; // one per timestep
};


#endif
