// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: WavefrontOBJPluginInfo.C
// ****************************************************************************

#include <WavefrontOBJPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(WavefrontOBJ,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(WavefrontOBJ,General)

// ****************************************************************************
//  Method: WavefrontOBJGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
WavefrontOBJGeneralPluginInfo::GetName() const
{
    return "WavefrontOBJ";
}

// ****************************************************************************
//  Method: WavefrontOBJGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
WavefrontOBJGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: WavefrontOBJGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
WavefrontOBJGeneralPluginInfo::GetID() const
{
    return "WavefrontOBJ_1.0";
}
// ****************************************************************************
//  Method: WavefrontOBJGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
WavefrontOBJGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: WavefrontOBJGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
WavefrontOBJGeneralPluginInfo::HasWriter() const
{
    return true;
}
// ****************************************************************************
//  Method:  WavefrontOBJGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a WavefrontOBJ database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
WavefrontOBJGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.obj");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  WavefrontOBJGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a WavefrontOBJ database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
WavefrontOBJGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  WavefrontOBJGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the WavefrontOBJ plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
WavefrontOBJGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
