// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: VelodynePluginInfo.C
// ****************************************************************************

#include <VelodynePluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Velodyne,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(Velodyne,General)

// ****************************************************************************
//  Method: VelodyneGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VelodyneGeneralPluginInfo::GetName() const
{
    return "Velodyne";
}

// ****************************************************************************
//  Method: VelodyneGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VelodyneGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: VelodyneGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VelodyneGeneralPluginInfo::GetID() const
{
    return "Velodyne_1.0";
}
// ****************************************************************************
//  Method: VelodyneGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
VelodyneGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: VelodyneGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
VelodyneGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  VelodyneGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a Velodyne database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
VelodyneGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.vld");
    defaultPatterns.push_back("*.rst");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  VelodyneGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a Velodyne database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
VelodyneGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  VelodyneGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the Velodyne plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
VelodyneGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
