// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtTCGAFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_TCGA_FILE_FORMAT_H
#define AVT_TCGA_FILE_FORMAT_H

#include <avtSTMDFileFormat.h>

#include <vector>
#include <string>

// ****************************************************************************
//  Class: avtTCGAFileFormat
//
//  Purpose:
//      Reads in TCGA files as a plugin to VisIt.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Mon Nov 3 15:46:13 PST 2014
//
// ****************************************************************************

class avtTCGAFileFormat : public avtSTMDFileFormat
{
  public:
                       avtTCGAFileFormat(const char *);
    virtual           ~avtTCGAFileFormat() {;};

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, int domain,
    //                                     const char *type, void *args, 
    //                                     DestructorFunction &);
    //

    //
    // If you know the cycle number, overload this function.
    // Otherwise, VisIt will make up a reasonable one for you.
    //
    // virtual int         GetCycle(void);
    //

    virtual const char    *GetType(void)   { return "TCGA"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

  protected:
    void Initialize();
    bool initialized;
    std::vector<std::string> imageFiles, contourFiles;
    int imageSize[2];

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);
};


#endif
