// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: StreamGhostTestPluginInfo.C
// ****************************************************************************

#include <StreamGhostTestPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(StreamGhostTest,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(StreamGhostTest,General)

// ****************************************************************************
//  Method: StreamGhostTestGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
StreamGhostTestGeneralPluginInfo::GetName() const
{
    return "StreamGhostTest";
}

// ****************************************************************************
//  Method: StreamGhostTestGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
StreamGhostTestGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: StreamGhostTestGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
StreamGhostTestGeneralPluginInfo::GetID() const
{
    return "StreamGhostTest_1.0";
}
// ****************************************************************************
//  Method: StreamGhostTestGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
StreamGhostTestGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: StreamGhostTestGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
StreamGhostTestGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  StreamGhostTestGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a StreamGhostTest database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
StreamGhostTestGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.sgt");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  StreamGhostTestGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a StreamGhostTest database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
StreamGhostTestGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  StreamGhostTestGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the StreamGhostTest plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
StreamGhostTestGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
