// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                          avtShapefileOptions.C                            //
// ************************************************************************* //

#include <avtShapefileOptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>

using std::string;
using std::vector;


// ****************************************************************************
//  Function: GetShapefileReadOptions
//
//  Purpose:
//      Creates the options for Shapefile readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: miller -- generated by hand 
//  Creation:   April 29, 2008 
//
//  Modifications:
//    Brad Whitlock, Wed Feb  3 16:31:01 PST 2010
//    I renamed the tessellation option since it was the NOT case.
//
// ****************************************************************************

DBOptionsAttributes *
GetShapefileReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    rv->SetBool("Polygons as lines", false);
    rv->SetBool("Tessellate polygons", true);
    rv->SetBool("ESRI Logging", false);
    rv->SetBool("DBF Logging", false);
    return rv;
}


// ****************************************************************************
//  Function: GetShapefileWriteOptions
//
//  Purpose:
//      Creates the options for Shapefile writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: miller -- generated by hand 
//  Creation:   April 29, 2008 
//
// ****************************************************************************

DBOptionsAttributes *
GetShapefileWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
