// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ShapefilePluginInfo.C
// ****************************************************************************

#include <ShapefilePluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Shapefile,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(Shapefile,General)

// ****************************************************************************
//  Method: ShapefileGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ShapefileGeneralPluginInfo::GetName() const
{
    return "Shapefile";
}

// ****************************************************************************
//  Method: ShapefileGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ShapefileGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: ShapefileGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ShapefileGeneralPluginInfo::GetID() const
{
    return "Shapefile_1.0";
}
// ****************************************************************************
//  Method: ShapefileGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ShapefileGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: ShapefileGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
ShapefileGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  ShapefileGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a Shapefile database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
ShapefileGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.shp");
    defaultPatterns.push_back("*.shx");
    defaultPatterns.push_back("*.dbf");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  ShapefileGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a Shapefile database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ShapefileGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  ShapefileGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the Shapefile plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
ShapefileGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
