// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <SPCTHPluginInfo.h>
#include <avtSPCTHFileFormat.h>
#include <avtMTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  SPCTHCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a SPCTH database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
SPCTHCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTMD;
}

// ****************************************************************************
//  Method: SPCTHCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a SPCTH database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A SPCTH database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
SPCTHCommonPluginInfo::SetupDatabase(const char *const *list,
                                     int nList,
                                     int nBlock)
{
    avtMTMDFileFormat **ffl = new avtMTMDFileFormat*[1];
    ffl[0] = new avtSPCTHFileFormat(list[0]);

    if(nList > 1)
    {
        avtSPCTHFileFormat *ff = dynamic_cast<avtSPCTHFileFormat *>(ffl[0]);
        ff->SetFileList(list, nList);
    }

    avtMTMDFileFormatInterface *inter
           = new avtMTMDFileFormatInterface(ffl, 1);
    return new avtGenericDatabase(inter);
}

